/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSetImpl;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.player.PlayerSetFactory;
import de.codecrafter47.taboverlay.config.player.PlayerSetPartition;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class VisibleToAdminsPlayerSetWrapper
implements PlayerSet {
    private final PlayerSetFactory playerSetFactory;
    protected final Context context;
    private final Logger logger;
    private final PlayerSetTemplate templateVisible;
    private final PlayerSetTemplate templateInvisible;
    private final ToBooleanExpression expressionCanSeeHiddenPlayers;
    private final MyListener listener;
    private final HashSet<PlayerSet.Listener> listeners = new HashSet();
    @Nullable
    private PlayerSet playerSet;
    private boolean canSeeHiddenPlayers;
    private boolean isNotifyingListeners = false;

    public VisibleToAdminsPlayerSetWrapper(PlayerSetFactory playerSetFactory, Context context, Logger logger, PlayerSetTemplate templateVisible, PlayerSetTemplate templateInvisible, ExpressionTemplate canSeeHiddenPlayersTemplate) {
        this.playerSetFactory = playerSetFactory;
        this.context = context;
        this.logger = logger;
        this.templateVisible = templateVisible;
        this.templateInvisible = templateInvisible;
        this.listener = new MyListener();
        this.expressionCanSeeHiddenPlayers = canSeeHiddenPlayersTemplate.instantiateWithBooleanResult();
    }

    private void activate() {
        this.expressionCanSeeHiddenPlayers.activate(this.context, this.listener);
        this.canSeeHiddenPlayers = this.expressionCanSeeHiddenPlayers.evaluate();
        this.playerSet = this.playerSetFactory.getInstance(this.canSeeHiddenPlayers ? this.templateVisible : this.templateInvisible);
        this.playerSet.addListener(this.listener);
    }

    private void deactivate() {
        this.expressionCanSeeHiddenPlayers.deactivate();
        this.playerSet.removeListener(this.listener);
        this.playerSet = null;
    }

    @Override
    public int getCount() {
        if (this.playerSet == null) {
            throw new IllegalStateException("Calling PlayerSet.getCount() before registering a listener");
        }
        return this.playerSet.getCount();
    }

    @Override
    public void addListener(PlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be added while notifying listeners");
        }
        this.listeners.add(listener);
        if (this.playerSet == null) {
            this.activate();
        }
    }

    @Override
    public void removeListener(PlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be removed while notifying listeners");
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.playerSet != null) {
            this.deactivate();
        }
    }

    @Override
    public Collection<? extends Player> getPlayers() {
        if (this.playerSet == null) {
            throw new IllegalStateException("Calling PlayerSet.getPlayers() before registering a listener");
        }
        return this.playerSet.getPlayers();
    }

    @Override
    public OrderedPlayerSet getOrderedPlayerSet(Context context, PlayerOrderTemplate playerOrderTemplate) {
        return new OrderedPlayerSetImpl(this, this.logger, context, playerOrderTemplate);
    }

    @Override
    public PlayerSetPartition getPartition(ExpressionTemplate partitionFunction) {
        return new PlayerSetPartition(this.context.getTabEventQueue(), this, this.logger, partitionFunction, this.context);
    }

    private class MyListener
    implements PlayerSet.Listener,
    ExpressionUpdateListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerAdded(Player player) {
            VisibleToAdminsPlayerSetWrapper.this.isNotifyingListeners = true;
            try {
                for (PlayerSet.Listener listener : VisibleToAdminsPlayerSetWrapper.this.listeners) {
                    try {
                        listener.onPlayerAdded(player);
                    }
                    catch (Throwable th) {
                        VisibleToAdminsPlayerSetWrapper.this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                    }
                }
            }
            finally {
                VisibleToAdminsPlayerSetWrapper.this.isNotifyingListeners = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlayerRemoved(Player player) {
            VisibleToAdminsPlayerSetWrapper.this.isNotifyingListeners = true;
            try {
                for (PlayerSet.Listener listener : VisibleToAdminsPlayerSetWrapper.this.listeners) {
                    try {
                        listener.onPlayerRemoved(player);
                    }
                    catch (Throwable th) {
                        VisibleToAdminsPlayerSetWrapper.this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                    }
                }
            }
            finally {
                VisibleToAdminsPlayerSetWrapper.this.isNotifyingListeners = false;
            }
        }

        @Override
        public void onExpressionUpdate() {
            boolean canSeeHiddenPlayers = VisibleToAdminsPlayerSetWrapper.this.expressionCanSeeHiddenPlayers.evaluate();
            if (VisibleToAdminsPlayerSetWrapper.this.canSeeHiddenPlayers != canSeeHiddenPlayers) {
                VisibleToAdminsPlayerSetWrapper.this.canSeeHiddenPlayers = canSeeHiddenPlayers;
                VisibleToAdminsPlayerSetWrapper.this.playerSet.getPlayers().forEach(this::onPlayerRemoved);
                VisibleToAdminsPlayerSetWrapper.this.playerSet.removeListener(VisibleToAdminsPlayerSetWrapper.this.listener);
                VisibleToAdminsPlayerSetWrapper.this.playerSet = VisibleToAdminsPlayerSetWrapper.this.playerSetFactory.getInstance(canSeeHiddenPlayers ? VisibleToAdminsPlayerSetWrapper.this.templateVisible : VisibleToAdminsPlayerSetWrapper.this.templateInvisible);
                VisibleToAdminsPlayerSetWrapper.this.playerSet.addListener(VisibleToAdminsPlayerSetWrapper.this.listener);
                VisibleToAdminsPlayerSetWrapper.this.playerSet.getPlayers().forEach(this::onPlayerAdded);
            }
        }
    }
}

