/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.AbstractPlayerSet;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSetImpl;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.player.PlayerSetPartition;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class SharedPlayerSet
extends AbstractPlayerSet {
    private final LoadingCache<ExpressionTemplate, PlayerSetPartition> cachePartition = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ExpressionTemplate, PlayerSetPartition>(){

        public PlayerSetPartition load(@Nonnull ExpressionTemplate key) {
            return new PlayerSetPartition(SharedPlayerSet.this.context.getTabEventQueue(), SharedPlayerSet.this, SharedPlayerSet.this.logger, key, SharedPlayerSet.this.context);
        }
    });
    private final Cache<PlayerOrderTemplate, OrderedPlayerSet> cacheOrdered = CacheBuilder.newBuilder().weakValues().build();

    public SharedPlayerSet(PlayerProvider playerProvider, ExpressionTemplate template, ScheduledExecutorService eventQueue, Logger logger) {
        super(eventQueue, playerProvider, logger, template, Context.from(null, eventQueue));
    }

    @Override
    public PlayerSetPartition getPartition(ExpressionTemplate partitionFunction) {
        return (PlayerSetPartition)this.cachePartition.get((Object)partitionFunction);
    }

    @Override
    public OrderedPlayerSet getOrderedPlayerSet(Context context, PlayerOrderTemplate playerOrderTemplate) {
        if (playerOrderTemplate.requiresViewerContext()) {
            return super.getOrderedPlayerSet(context, playerOrderTemplate);
        }
        return (OrderedPlayerSet)this.cacheOrdered.get((Object)playerOrderTemplate, () -> new OrderedPlayerSetImpl(this, this.logger, this.context, playerOrderTemplate));
    }
}

