/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSetImpl;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.view.ActiveElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PlayerSetPartition {
    private final PlayerSet playerSet;
    private final Logger logger;
    protected final ExpressionTemplate partitionFunction;
    protected final Context context;
    private final HashSet<Listener> listeners = new HashSet();
    private final MyListener listener = new MyListener();
    private final Map<Player, PlayerEntry> playerEntryMap = new HashMap<Player, PlayerEntry>();
    private final Map<String, PlayerSetSubset> partitions = new HashMap<String, PlayerSetSubset>();
    private boolean active = false;
    private boolean isNotifyingListeners = false;

    public PlayerSetPartition(ScheduledExecutorService eventQueue, PlayerSet playerSet, Logger logger, ExpressionTemplate partitionFunction, Context context) {
        this.logger = logger;
        this.context = context;
        this.playerSet = playerSet;
        this.partitionFunction = partitionFunction;
    }

    private void activate(boolean notify) {
        this.playerSet.addListener(this.listener);
        for (Player player : this.playerSet.getPlayers()) {
            this.playerEntryMap.put(player, new PlayerEntry(player, notify));
        }
        this.active = true;
    }

    private void deactivate() {
        for (PlayerEntry playerEntry : this.playerEntryMap.values()) {
            playerEntry.deactivate();
        }
        this.playerEntryMap.clear();
        this.playerSet.removeListener(this.listener);
        this.active = false;
    }

    public Collection<? extends Map.Entry<String, ? extends PlayerSet>> getPartitions() {
        return this.partitions.entrySet();
    }

    public PlayerSet getPartition(String name) {
        return this.partitions.get(name);
    }

    public void addListener(Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be added while notifying listeners");
        }
        this.listeners.add(listener);
        if (!this.active) {
            this.activate(false);
        }
    }

    public void removeListener(Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be removed while notifying listeners");
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.active) {
            this.deactivate();
        }
    }

    private class MyListener
    implements PlayerSet.Listener {
        private MyListener() {
        }

        @Override
        public void onPlayerAdded(Player player) {
            PlayerSetPartition.this.playerEntryMap.put(player, new PlayerEntry(player, true));
        }

        @Override
        public void onPlayerRemoved(Player player) {
            PlayerEntry playerEntry = (PlayerEntry)PlayerSetPartition.this.playerEntryMap.remove(player);
            if (playerEntry == null) {
                throw new AssertionError((Object)"Tried to remove a player that is not part of the player set");
            }
            playerEntry.deactivate();
        }
    }

    private class PlayerEntry
    implements ActiveElement,
    ExpressionUpdateListener {
        private final Player player;
        private final ToStringExpression function;
        private String partition;

        private PlayerEntry(Player player, boolean notify) {
            this.player = player;
            this.function = PlayerSetPartition.this.partitionFunction.instantiateWithStringResult();
            Context childContext = PlayerSetPartition.this.context.clone();
            childContext.setPlayer(player);
            this.function.activate(childContext, this);
            this.partition = this.function.evaluate();
            this.addToPartition(this.partition, notify);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToPartition(String p, boolean notify) {
            if (!PlayerSetPartition.this.partitions.containsKey(p)) {
                PlayerSetSubset subset = new PlayerSetSubset(PlayerSetPartition.this.context, PlayerSetPartition.this.logger);
                subset.add(this.player);
                PlayerSetPartition.this.partitions.put(p, subset);
                if (notify) {
                    PlayerSetPartition.this.isNotifyingListeners = true;
                    try {
                        for (Listener listener1 : PlayerSetPartition.this.listeners) {
                            try {
                                listener1.onPartitionAdded(p, subset);
                            }
                            catch (Throwable th) {
                                PlayerSetPartition.this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                            }
                        }
                    }
                    finally {
                        PlayerSetPartition.this.isNotifyingListeners = false;
                    }
                }
            } else {
                ((PlayerSetSubset)PlayerSetPartition.this.partitions.get(p)).add(this.player);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeFromPartition(String p) {
            PlayerSetSubset subset = (PlayerSetSubset)PlayerSetPartition.this.partitions.get(p);
            subset.remove(this.player);
            if (subset.getCount() == 0) {
                PlayerSetPartition.this.partitions.remove(p);
                PlayerSetPartition.this.isNotifyingListeners = true;
                try {
                    for (Listener listener1 : PlayerSetPartition.this.listeners) {
                        try {
                            listener1.onPartitionRemoved(p);
                        }
                        catch (Throwable th) {
                            PlayerSetPartition.this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                        }
                    }
                }
                finally {
                    PlayerSetPartition.this.isNotifyingListeners = false;
                }
            }
        }

        @Override
        public void onExpressionUpdate() {
            String partition = this.function.evaluate();
            if (!Objects.equals(partition, this.partition)) {
                this.removeFromPartition(this.partition);
                this.partition = partition;
                this.addToPartition(this.partition, true);
            }
        }

        @Override
        public void deactivate() {
            this.function.deactivate();
            this.removeFromPartition(this.partition);
        }
    }

    public static interface Listener {
        public void onPartitionAdded(String var1, PlayerSet var2);

        public void onPartitionRemoved(String var1);
    }

    private static class PlayerSetSubset
    implements PlayerSet {
        private final Context context;
        private final Logger logger;
        private final HashSet<PlayerSet.Listener> listeners = new HashSet();
        private final Set<Player> containedPlayers = new HashSet<Player>();
        private final Cache<PlayerOrderTemplate, OrderedPlayerSet> cacheOrdered = CacheBuilder.newBuilder().weakValues().build();
        private boolean isNotifyingListeners = false;

        private PlayerSetSubset(Context context, Logger logger) {
            this.context = context;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Player player) {
            this.containedPlayers.add(player);
            this.isNotifyingListeners = true;
            try {
                for (PlayerSet.Listener listener : this.listeners) {
                    try {
                        listener.onPlayerAdded(player);
                    }
                    catch (Throwable th) {
                        this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                    }
                }
            }
            finally {
                this.isNotifyingListeners = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Player player) {
            this.containedPlayers.remove(player);
            this.isNotifyingListeners = true;
            try {
                for (PlayerSet.Listener listener : this.listeners) {
                    try {
                        listener.onPlayerRemoved(player);
                    }
                    catch (Throwable th) {
                        this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                    }
                }
            }
            finally {
                this.isNotifyingListeners = false;
            }
        }

        @Override
        public int getCount() {
            return this.containedPlayers.size();
        }

        @Override
        public void addListener(PlayerSet.Listener listener) {
            if (this.isNotifyingListeners) {
                throw new IllegalStateException("Listeners cannot be added while notifying listeners");
            }
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(PlayerSet.Listener listener) {
            if (this.isNotifyingListeners) {
                throw new IllegalStateException("Listeners cannot be removed while notifying listeners");
            }
            this.listeners.remove(listener);
        }

        @Override
        public Collection<? extends Player> getPlayers() {
            return this.containedPlayers;
        }

        @Override
        public PlayerSetPartition getPartition(ExpressionTemplate idFunction) {
            throw new UnsupportedOperationException("Partition inside partition is not supported");
        }

        @Override
        public OrderedPlayerSet getOrderedPlayerSet(Context context, PlayerOrderTemplate playerOrderTemplate) {
            if (playerOrderTemplate.requiresViewerContext()) {
                return new OrderedPlayerSetImpl(this, this.logger, context, playerOrderTemplate);
            }
            return (OrderedPlayerSet)this.cacheOrdered.get((Object)playerOrderTemplate, () -> new OrderedPlayerSetImpl(this, this.logger, this.context, playerOrderTemplate));
        }
    }
}

