/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.PlayerSetConfiguration;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import de.codecrafter47.taboverlay.config.player.GlobalPlayerSetFactory;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.player.SlowPlayerSet;
import de.codecrafter47.taboverlay.config.player.VisibleToAdminsPlayerSetWrapper;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class PlayerSetFactory {
    private final PlayerProvider playerProvider;
    private final GlobalPlayerSetFactory globalPlayerSetFactory;
    private final Logger logger;
    private final Context context;
    private final Map<PlayerSetTemplate, PlayerSet> cache = new HashMap<PlayerSetTemplate, PlayerSet>();

    public PlayerSetFactory(PlayerProvider playerProvider, GlobalPlayerSetFactory globalPlayerSetFactory, Logger logger, Context context) {
        this.playerProvider = playerProvider;
        this.globalPlayerSetFactory = globalPlayerSetFactory;
        this.logger = logger;
        this.context = context;
    }

    public PlayerSet getInstance(PlayerSetTemplate template) {
        return this.cache.computeIfAbsent(template, this::createPlayerSet);
    }

    private PlayerSet createPlayerSet(PlayerSetTemplate template) {
        PlayerSet playerSet = this.globalPlayerSetFactory.getSharedInstance(template);
        if (playerSet != null) {
            return playerSet;
        }
        switch (template.getHiddenPlayersVisibility()) {
            case VISIBLE: {
                return new SlowPlayerSet(this.playerProvider, template.getPredicate(), this.context, this.logger);
            }
            case VISIBLE_TO_ADMINS: {
                return new VisibleToAdminsPlayerSetWrapper(this, this.context, this.logger, PlayerSetTemplate.builder().predicate(template.getPredicate()).hiddenPlayersVisibility(PlayerSetConfiguration.Visibility.VISIBLE).build(), PlayerSetTemplate.builder().predicate(template.getPredicate()).hiddenPlayersVisibility(PlayerSetConfiguration.Visibility.INVISIBLE).build(), this.globalPlayerSetFactory.expressionTemplateCanSeeInvisible);
            }
            case INVISIBLE: {
                return new SlowPlayerSet(this.playerProvider, ExpressionTemplates.and(Arrays.asList(template.getPredicate(), this.globalPlayerSetFactory.expressionTemplateIsVisible)), this.context, this.logger);
            }
        }
        throw new AssertionError((Object)("Unknown player set visibility " + (Object)((Object)template.getHiddenPlayersVisibility())));
    }
}

