/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import de.codecrafter47.data.api.DataHolder;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.DataHolderPlaceholderDataProviderSupplier;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrderedPlayerSetImpl
implements OrderedPlayerSet {
    private final PlayerSet playerSet;
    private final Logger logger;
    protected final Context context;
    private final Comparator<Player> comparator;
    private final List<DataKey<?>> dependentDataKeys;
    private final HashSet<OrderedPlayerSet.Listener> listeners = new HashSet();
    private final MyListener listener = new MyListener();
    private final List<Player> containedPlayers = new ArrayList<Player>();
    private final List<Player> pendingPlayers = new ArrayList<Player>();
    private Player viewer;
    private boolean active = false;
    private Future<?> updateFuture = null;
    private boolean isNotifyingListeners = false;

    public OrderedPlayerSetImpl(PlayerSet playerSet, Logger logger, Context context, PlayerOrderTemplate playerOrderTemplate) {
        this.playerSet = playerSet;
        this.logger = logger;
        this.context = context;
        this.dependentDataKeys = new ArrayList();
        Comparator<DataHolder> chain = null;
        for (PlayerOrderTemplate.Entry entry : playerOrderTemplate.getEntries()) {
            Comparator<DataHolder> comparator = null;
            DataHolderPlaceholderDataProviderSupplier<DataHolder, ?, ?> placeholder = entry.getPlaceholder();
            switch (entry.getType()) {
                case TEXT: {
                    comparator = Comparator.comparing(placeholder.getToStringFunction(), Collator.getInstance());
                    break;
                }
                case NUMBER: {
                    comparator = Comparator.comparingDouble(placeholder.getToDoubleFunction());
                }
            }
            switch (entry.getDirection()) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    comparator = comparator.reversed();
                    break;
                }
                case VIEWER_FIRST: {
                    this.viewer = context.getViewer();
                    Function<DataHolder, String> toStringFunction = placeholder.getToStringFunction();
                    comparator = Comparator.comparingInt(player -> Objects.equals(toStringFunction.apply((DataHolder)player), toStringFunction.apply(this.viewer)) ? 0 : 1);
                    break;
                }
                case CUSTOM: {
                    Function<DataHolder, String> toStringFunction = placeholder.getToStringFunction();
                    List<String> customOrder = entry.getCustomOrder();
                    comparator = Comparator.comparingInt(player -> {
                        int index = customOrder.indexOf(toStringFunction.apply((DataHolder)player));
                        return index < 0 ? Integer.MAX_VALUE : index;
                    });
                }
            }
            chain = chain == null ? comparator : chain.thenComparing(comparator);
            if (placeholder.getDataKey() == null || this.dependentDataKeys.contains(placeholder.getDataKey())) continue;
            this.dependentDataKeys.add(placeholder.getDataKey());
        }
        if (chain == null) {
            chain = Comparator.comparingInt(player -> 0);
        }
        this.comparator = chain;
    }

    private void registerListeners(Player player) {
        for (DataKey<?> dataKey : this.dependentDataKeys) {
            player.addDataChangeListener(dataKey, this.listener);
        }
    }

    private void unregisterListeners(Player player) {
        for (DataKey<?> dataKey : this.dependentDataKeys) {
            player.removeDataChangeListener(dataKey, this.listener);
        }
    }

    private void activate() {
        this.playerSet.addListener(this.listener);
        if (this.viewer != null) {
            this.registerListeners(this.viewer);
        }
        for (Player player : this.playerSet.getPlayers()) {
            this.registerListeners(player);
            this.containedPlayers.add(player);
        }
        this.containedPlayers.sort(this.comparator);
        this.active = true;
    }

    private void deactivate() {
        if (this.viewer != null) {
            this.unregisterListeners(this.viewer);
        }
        for (Player player : this.playerSet.getPlayers()) {
            this.unregisterListeners(player);
        }
        this.containedPlayers.clear();
        this.pendingPlayers.clear();
        this.playerSet.removeListener(this.listener);
        this.active = false;
        if (this.updateFuture != null && !this.updateFuture.isDone()) {
            this.updateFuture.cancel(false);
        }
    }

    private void scheduleUpdate(int ms) {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.context.getTabEventQueue().schedule(this::update, (long)ms, TimeUnit.MILLISECONDS);
        }
    }

    private void update() {
        this.containedPlayers.addAll(this.pendingPlayers);
        this.containedPlayers.sort(this.comparator);
        this.notifyListenersOfUpdate(!this.pendingPlayers.isEmpty());
        this.pendingPlayers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfRemovedPlayer(Player player) {
        this.isNotifyingListeners = true;
        try {
            for (OrderedPlayerSet.Listener listener : this.listeners) {
                try {
                    listener.onPlayerRemoved(player);
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                }
            }
        }
        finally {
            this.isNotifyingListeners = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfUpdate(boolean newPlayers) {
        this.isNotifyingListeners = true;
        try {
            for (OrderedPlayerSet.Listener listener : this.listeners) {
                try {
                    listener.onUpdate(newPlayers);
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                }
            }
        }
        finally {
            this.isNotifyingListeners = false;
        }
    }

    @Override
    public void addListener(OrderedPlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be added while notifying listeners");
        }
        this.listeners.add(listener);
        if (!this.active) {
            this.activate();
        }
    }

    @Override
    public void removeListener(OrderedPlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be removed while notifying listeners");
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.active) {
            this.deactivate();
        }
    }

    @Override
    public int getCount() {
        return this.containedPlayers.size();
    }

    @Override
    public Player getPlayer(int index) {
        return this.containedPlayers.get(index);
    }

    private class MyListener
    implements Runnable,
    PlayerSet.Listener {
        private MyListener() {
        }

        @Override
        public void run() {
            OrderedPlayerSetImpl.this.scheduleUpdate(1000);
        }

        @Override
        public void onPlayerAdded(Player player) {
            OrderedPlayerSetImpl.this.registerListeners(player);
            OrderedPlayerSetImpl.this.pendingPlayers.add(player);
            OrderedPlayerSetImpl.this.scheduleUpdate(500);
        }

        @Override
        public void onPlayerRemoved(Player player) {
            if (player != OrderedPlayerSetImpl.this.viewer) {
                OrderedPlayerSetImpl.this.unregisterListeners(player);
            }
            if (!OrderedPlayerSetImpl.this.pendingPlayers.remove(player) && OrderedPlayerSetImpl.this.containedPlayers.remove(player)) {
                OrderedPlayerSetImpl.this.notifyListenersOfRemovedPlayer(player);
            }
        }
    }
}

