/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderDataProviderSupplier;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.player.SharedPlayerSet;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalPlayerSetFactory {
    private final PlayerProvider playerProvider;
    private final ScheduledExecutorService eventQueue;
    private final Logger logger;
    final ExpressionTemplate expressionTemplateIsVisible;
    final ExpressionTemplate expressionTemplateCanSeeInvisible;
    private final LoadingCache<PlayerSetTemplate, SharedPlayerSet> cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<PlayerSetTemplate, SharedPlayerSet>(){

        public SharedPlayerSet load(@Nonnull PlayerSetTemplate key) {
            switch (key.getHiddenPlayersVisibility()) {
                case VISIBLE: {
                    return new SharedPlayerSet(GlobalPlayerSetFactory.this.playerProvider, key.getPredicate(), GlobalPlayerSetFactory.this.eventQueue, GlobalPlayerSetFactory.this.logger);
                }
                case VISIBLE_TO_ADMINS: {
                    throw new IllegalArgumentException("PlayerSet with VISIBLE_TO_ADMINS can't be shared");
                }
                case INVISIBLE: {
                    return new SharedPlayerSet(GlobalPlayerSetFactory.this.playerProvider, ExpressionTemplates.and(Arrays.asList(key.getPredicate(), GlobalPlayerSetFactory.this.expressionTemplateIsVisible)), GlobalPlayerSetFactory.this.eventQueue, GlobalPlayerSetFactory.this.logger);
                }
            }
            throw new AssertionError((Object)("Unknown player visibility " + (Object)((Object)key.getHiddenPlayersVisibility())));
        }
    });

    public GlobalPlayerSetFactory(PlayerProvider playerProvider, ScheduledExecutorService eventQueue, Logger logger, DataKey<Boolean> DATA_KEY_IS_HIDDEN, DataKey<Boolean> DATA_KEY_CAN_SEE_INVISIBLE) {
        this.playerProvider = playerProvider;
        this.eventQueue = eventQueue;
        this.logger = logger;
        this.expressionTemplateIsVisible = ExpressionTemplates.negate(PlaceholderBuilder.create().transformContext(Context::getPlayer).acquireData(new PlayerPlaceholderDataProviderSupplier<Boolean, Boolean>(TypeToken.BOOLEAN, DATA_KEY_IS_HIDDEN, (p, i) -> i == null ? false : i), TypeToken.BOOLEAN).requireViewerContext(false).build());
        this.expressionTemplateCanSeeInvisible = PlaceholderBuilder.create().transformContext(Context::getViewer).acquireData(new PlayerPlaceholderDataProviderSupplier<Boolean, Boolean>(TypeToken.BOOLEAN, DATA_KEY_CAN_SEE_INVISIBLE, (p, i) -> i == null ? false : i), TypeToken.BOOLEAN).requireViewerContext(true).build();
    }

    @Nullable
    public PlayerSet getSharedInstance(PlayerSetTemplate template) {
        if (!template.isRequiresViewerContext()) {
            return (PlayerSet)this.cache.get((Object)template);
        }
        return null;
    }
}

