/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.player;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSet;
import de.codecrafter47.taboverlay.config.player.OrderedPlayerSetImpl;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.view.ActiveElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPlayerSet
implements PlayerSet {
    private final PlayerProvider playerProvider;
    final Logger logger;
    private final ExpressionTemplate predicate;
    protected final Context context;
    private final HashSet<PlayerSet.Listener> listeners = new HashSet();
    private final MyListener listener = new MyListener();
    private final Map<Player, PlayerEntry> playerEntryMap = new HashMap<Player, PlayerEntry>();
    private final Set<Player> containedPlayers = new HashSet<Player>();
    private boolean active = false;
    private boolean isNotifyingListeners = false;

    AbstractPlayerSet(ScheduledExecutorService eventQueue, PlayerProvider playerProvider, Logger logger, ExpressionTemplate predicate, Context context) {
        this.logger = logger;
        this.context = context;
        this.playerProvider = playerProvider;
        this.predicate = predicate;
    }

    private void activate() {
        this.playerProvider.registerListener(this.listener);
        for (Player player : this.playerProvider.getPlayers()) {
            this.playerEntryMap.put(player, new PlayerEntry(player));
        }
        this.active = true;
    }

    private void deactivate() {
        for (PlayerEntry playerEntry : this.playerEntryMap.values()) {
            playerEntry.deactivate();
        }
        this.playerEntryMap.clear();
        this.playerProvider.unregisterListener(this.listener);
        this.active = false;
    }

    @Override
    public int getCount() {
        return this.containedPlayers.size();
    }

    @Override
    public void addListener(PlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be added while notifying listeners");
        }
        if (!this.active) {
            this.activate();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(PlayerSet.Listener listener) {
        if (this.isNotifyingListeners) {
            throw new IllegalStateException("Listeners cannot be removed while notifying listeners");
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.active) {
            this.deactivate();
        }
    }

    @Override
    public Collection<? extends Player> getPlayers() {
        return this.containedPlayers;
    }

    @Override
    public OrderedPlayerSet getOrderedPlayerSet(Context context, PlayerOrderTemplate playerOrderTemplate) {
        return new OrderedPlayerSetImpl(this, this.logger, context, playerOrderTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlayerAndNotifyListeners(Player player) {
        this.containedPlayers.add(player);
        this.isNotifyingListeners = true;
        try {
            for (PlayerSet.Listener listener : this.listeners) {
                try {
                    listener.onPlayerAdded(player);
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                }
            }
        }
        finally {
            this.isNotifyingListeners = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlayerAndNotifyListeners(Player player) {
        this.containedPlayers.remove(player);
        this.isNotifyingListeners = true;
        try {
            for (PlayerSet.Listener listener : this.listeners) {
                try {
                    listener.onPlayerRemoved(player);
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Unexpected exception while notifying listener", th);
                }
            }
        }
        finally {
            this.isNotifyingListeners = false;
        }
    }

    private class MyListener
    implements PlayerProvider.Listener {
        private MyListener() {
        }

        @Override
        public void onPlayerAdded(Player player) {
            AbstractPlayerSet.this.playerEntryMap.put(player, new PlayerEntry(player));
        }

        @Override
        public void onPlayerRemoved(Player player) {
            PlayerEntry playerEntry = (PlayerEntry)AbstractPlayerSet.this.playerEntryMap.remove(player);
            if (playerEntry == null) {
                throw new AssertionError((Object)"Tried to remove a player that is not part of the player set");
            }
            playerEntry.deactivate();
        }
    }

    private class PlayerEntry
    implements ActiveElement,
    ExpressionUpdateListener {
        private final Player player;
        private final ToBooleanExpression predicate;
        private boolean included;

        private PlayerEntry(Player player) {
            this.player = player;
            this.predicate = AbstractPlayerSet.this.predicate.instantiateWithBooleanResult();
            Context childContext = AbstractPlayerSet.this.context.clone();
            childContext.setPlayer(player);
            this.predicate.activate(childContext, this);
            this.included = this.predicate.evaluate();
            if (this.included) {
                AbstractPlayerSet.this.addPlayerAndNotifyListeners(player);
            }
        }

        @Override
        public void onExpressionUpdate() {
            boolean include = this.predicate.evaluate();
            if (include != this.included) {
                if (include) {
                    AbstractPlayerSet.this.addPlayerAndNotifyListeners(this.player);
                } else {
                    AbstractPlayerSet.this.removePlayerAndNotifyListeners(this.player);
                }
                this.included = include;
            }
        }

        @Override
        public void deactivate() {
            this.predicate.deactivate();
            if (this.included) {
                AbstractPlayerSet.this.removePlayerAndNotifyListeners(this.player);
            }
        }
    }
}

