/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.ConfigTabOverlayManager;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class TimePlaceholderResolver
implements PlaceholderResolver<Context> {
    private static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final TypeToken<Long> TYPE_TOKEN_LONG = TypeToken.create();
    private final ConfigTabOverlayManager configTabOverlayManager;

    public TimePlaceholderResolver(ConfigTabOverlayManager configTabOverlayManager) {
        this.configTabOverlayManager = configTabOverlayManager;
    }

    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() >= 1 && args.get(0) instanceof PlaceholderArg.Text && "time".equalsIgnoreCase(((PlaceholderArg.Text)args.get(0)).getValue())) {
            SimpleDateFormat format = DEFAULT_FORMAT;
            if (args.size() > 1) {
                StringBuilder formatString = new StringBuilder();
                for (int i = 1; i < args.size(); ++i) {
                    String s;
                    if (args.get(i) instanceof PlaceholderArg.Text) {
                        s = ((PlaceholderArg.Text)args.get(i)).getValue();
                        if (i != 1) {
                            formatString.append(' ');
                        }
                    } else {
                        throw new PlaceholderException("Use of placeholder in time format is not allowed");
                    }
                    formatString.append(s);
                }
                try {
                    TimeZone timeZone = this.configTabOverlayManager.getTimeZone();
                    format = new SimpleDateFormat(formatString.toString());
                    if (timeZone != null) {
                        format.setTimeZone(timeZone);
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new PlaceholderException("Invalid time format", ex);
                }
            }
            args.clear();
            return builder.acquireData(() -> new TimeProvider(), TYPE_TOKEN_LONG, false).transformData(format::format, TypeToken.STRING);
        }
        throw new UnknownPlaceholderException();
    }

    private static class TimeProvider
    implements PlaceholderDataProvider<Context, Long> {
        private ScheduledFuture<?> future;

        private TimeProvider() {
        }

        @Override
        public void activate(Context context, Runnable listener) {
            this.future = context.getTabEventQueue().scheduleWithFixedDelay(listener, 1L, 1L, TimeUnit.SECONDS);
        }

        @Override
        public void deactivate() {
            this.future.cancel(false);
        }

        @Override
        public Long getData() {
            return System.currentTimeMillis();
        }
    }
}

