/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import java.util.List;
import javax.annotation.Nonnull;

public class PlayerSetPlaceholderResolver
implements PlaceholderResolver<Context> {
    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() >= 1 && args.get(0) instanceof PlaceholderArg.Text && args.get(0).getText().startsWith("playerset:")) {
            String playerSetId = args.get(0).getText().substring(10);
            PlayerSetTemplate playerSetTemplate = tcc.getPlayerSets().get(playerSetId);
            if (playerSetTemplate == null) {
                throw new PlaceholderException("Unknown player set " + playerSetId);
            }
            args.remove(0);
            if (!args.isEmpty() && "size".equals(args.get(0).getText())) {
                args.remove(0);
            }
            return builder.acquireData(() -> new PlayerCountDataProvider(playerSetTemplate), TypeToken.INTEGER, playerSetTemplate.isRequiresViewerContext());
        }
        throw new UnknownPlaceholderException();
    }

    private static class PlayerCountDataProvider
    extends AbstractActiveElement<Runnable>
    implements PlaceholderDataProvider<Context, Integer>,
    PlayerSet.Listener {
        private final PlayerSetTemplate playerSetTemplate;
        private PlayerSet playerSet;

        private PlayerCountDataProvider(PlayerSetTemplate playerSetTemplate) {
            this.playerSetTemplate = playerSetTemplate;
        }

        @Override
        protected void onActivation() {
            this.playerSet = this.getContext().getPlayerSetFactory().getInstance(this.playerSetTemplate);
            this.playerSet.addListener(this);
        }

        @Override
        protected void onDeactivation() {
            this.playerSet.removeListener(this);
        }

        @Override
        public Integer getData() {
            return this.playerSet.getCount();
        }

        @Override
        public void onPlayerAdded(Player player) {
            if (this.hasListener()) {
                ((Runnable)this.getListener()).run();
            }
        }

        @Override
        public void onPlayerRemoved(Player player) {
            if (this.hasListener()) {
                ((Runnable)this.getListener()).run();
            }
        }
    }
}

