/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class PlayerPlaceholderResolver
implements PlaceholderResolver<Context> {
    private final PlaceholderResolver<Player> delegate;
    private final BindPoint bindPoint;
    private final String prefix;

    public PlayerPlaceholderResolver(PlaceholderResolver<Player> delegate, BindPoint bindPoint) {
        this.delegate = delegate;
        this.bindPoint = bindPoint;
        this.prefix = bindPoint == BindPoint.PLAYER ? "player" : "viewer";
    }

    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() < 1) {
            throw new UnknownPlaceholderException();
        }
        if (!this.prefix.equals(args.get(0).getText())) {
            throw new UnknownPlaceholderException();
        }
        if (this.bindPoint == BindPoint.VIEWER && !tcc.isViewerAvailable()) {
            throw new PlaceholderException("viewer bound placeholders not available in the current context");
        }
        if (this.bindPoint == BindPoint.PLAYER && !tcc.isPlayerAvailable()) {
            StringBuilder suggest = new StringBuilder("viewer");
            for (int i = 1; i < args.size(); ++i) {
                String token = args.get(i).getText();
                suggest.append(' ');
                suggest.append(token);
            }
            throw new PlaceholderException("player bound placeholders not available in the current context\nNote: You might want to use ${" + suggest + "} instead");
        }
        args.remove(0);
        try {
            return this.delegate.resolve(builder.transformContext(this.bindPoint.contextTransformation), args, tcc).requireViewerContext(this.bindPoint == BindPoint.VIEWER);
        }
        catch (UnknownPlaceholderException ignored) {
            throw new PlaceholderException("Unknown placeholder");
        }
    }

    public static enum BindPoint {
        VIEWER(Context::getViewer),
        PLAYER(Context::getPlayer);

        private Function<Context, Player> contextTransformation;

        private BindPoint(Function<Context, Player> contextTransformation) {
            this.contextTransformation = contextTransformation;
        }
    }
}

