/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.placeholder.Placeholder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderParser {
    private static final Pattern PATTERN = Pattern.compile("(?ms)(\\$\\{|}|\\s)");
    private static Map<TypeToken<?>, Function<String, Function<?, String>>> dataRepresentations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Placeholder parse(String text, ParsePosition position, Mark mark, TemplateCreationContext tcc) {
        ArrayList<PlaceholderArg> args = new ArrayList<PlaceholderArg>();
        ArrayList<PlaceholderArg> complexArgParts = new ArrayList<PlaceholderArg>();
        int placeholderStartPosition = position.getIndex() - 2;
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find(position.getIndex())) {
            if (matcher.start() != position.getIndex()) {
                complexArgParts.add(new PlaceholderArg.Text(text.substring(position.getIndex(), matcher.start())));
            }
            position.setIndex(matcher.end());
            if ("${".equals(matcher.group())) {
                complexArgParts.add(new PlaceholderArg.Placeholder(PlaceholderParser.parse(text, position, mark, tcc), text.substring(matcher.start(), position.getIndex())));
            } else if (complexArgParts.size() == 1) {
                args.add((PlaceholderArg)complexArgParts.remove(0));
            } else if (complexArgParts.size() > 1) {
                args.add(new PlaceholderArg.Complex(complexArgParts));
                complexArgParts = new ArrayList();
            }
            if (!"}".equals(matcher.group())) continue;
            String placeholderText = text.substring(placeholderStartPosition, position.getIndex());
            tcc.getErrorHandler().enterContext("in use of placeholder " + placeholderText, mark);
            try {
                Object format;
                PlaceholderBuilder<?, ?> builder = tcc.getPlaceholderResolverChain().resolve(PlaceholderBuilder.create(), (List<PlaceholderArg>)args, tcc);
                if (!args.isEmpty()) {
                    if (args.size() == 1 && args.get(0) instanceof PlaceholderArg.Text) {
                        format = ((PlaceholderArg)args.get(0)).getText();
                        builder = PlaceholderParser.applyFormat(builder, (String)format);
                    } else if (args.size() > 1) {
                        tcc.getErrorHandler().addWarning("Parts of the placeholder text have been ignored.", null);
                    } else {
                        tcc.getErrorHandler().addWarning("Use of placeholders in format string is not allowed.", null);
                    }
                }
                format = builder.build();
                tcc.getErrorHandler().leaveContext();
                return format;
            }
            catch (Throwable throwable) {
                try {
                    tcc.getErrorHandler().leaveContext();
                    throw throwable;
                }
                catch (UnknownPlaceholderException e) {
                    tcc.getErrorHandler().addWarning("Unknown placeholder " + placeholderText, mark);
                }
                catch (PlaceholderException e) {
                    String message = "Error in placeholder " + placeholderText + ":\n" + e.getMessage();
                    if (e.getCause() != null) {
                        message = message + "\nCaused by: " + e.getCause().getMessage();
                    }
                    tcc.getErrorHandler().addWarning(message, mark);
                }
            }
            return Placeholder.DUMMY;
        }
        tcc.getErrorHandler().addWarning("Encountered missing `}` while parsing placeholder.", mark);
        return Placeholder.DUMMY;
    }

    private static PlaceholderBuilder<?, ?> applyFormat(PlaceholderBuilder<?, ?> builder, String format) {
        Function<String, Function<?, String>> representationFunction = dataRepresentations.get(builder.getType());
        if (representationFunction != null) {
            builder = builder.transformData(representationFunction.apply(format), TypeToken.STRING);
        }
        return builder;
    }

    static {
        dataRepresentations.put(TypeToken.INTEGER, arg -> {
            String format = "%0" + arg + "d";
            String.format(format, 1);
            return v -> {
                if (v == null) {
                    return "";
                }
                return String.format(format, v);
            };
        });
        dataRepresentations.put(TypeToken.FLOAT, arg -> {
            String format = "%0" + arg + "f";
            String.format(format, Float.valueOf(1.0f));
            return v -> {
                if (v == null) {
                    return "";
                }
                return String.format(format, v);
            };
        });
        dataRepresentations.put(TypeToken.DOUBLE, arg -> {
            String format = "%0" + arg + "f";
            String.format(format, Float.valueOf(1.0f));
            return v -> {
                if (v == null) {
                    return "";
                }
                return String.format(format, v);
            };
        });
        dataRepresentations.put(TypeToken.STRING, arg -> {
            int length = Integer.parseInt(arg);
            return v -> {
                if (v == null) {
                    return "";
                }
                return v.length() > length ? v.substring(0, length) : v;
            };
        });
    }
}

