/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.GenericPlaceholder;
import de.codecrafter47.taboverlay.config.placeholder.Placeholder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import java.util.function.Function;
import java.util.function.Supplier;

public class PlaceholderBuilder<C, D> {
    Function<Context, C> contextTransformation;
    private Supplier<PlaceholderDataProvider<C, D>> dataProviderFactory;
    private TypeToken<D> typeToken;
    private boolean requiresViewerContext;

    private PlaceholderBuilder(Function<Context, C> contextTransformation) {
        this.contextTransformation = contextTransformation;
    }

    private PlaceholderBuilder(Function<Context, C> contextTransformation, Supplier<PlaceholderDataProvider<C, D>> dataProviderFactory, TypeToken<D> typeToken, boolean requiresViewerContext) {
        this.contextTransformation = contextTransformation;
        this.dataProviderFactory = dataProviderFactory;
        this.typeToken = typeToken;
        this.requiresViewerContext = requiresViewerContext;
    }

    public static PlaceholderBuilder<Context, Void> create() {
        return new PlaceholderBuilder<Context, Void>(Function.identity());
    }

    public <C2> PlaceholderBuilder<C2, Void> transformContext(Function<C, C2> transformation) {
        return new PlaceholderBuilder<C2, D>(this.contextTransformation.andThen(transformation));
    }

    public <D2> PlaceholderBuilder<C, D2> acquireData(Supplier<PlaceholderDataProvider<C, D2>> dataProviderFactory, TypeToken<D2> typeToken) {
        return new PlaceholderBuilder<C, D>(this.contextTransformation, dataProviderFactory, typeToken, this.requiresViewerContext);
    }

    public <D2> PlaceholderBuilder<C, D2> acquireData(Supplier<PlaceholderDataProvider<C, D2>> dataProviderFactory, TypeToken<D2> typeToken, boolean requiresViewerContext) {
        return new PlaceholderBuilder<C, D>(this.contextTransformation, dataProviderFactory, typeToken, requiresViewerContext);
    }

    public PlaceholderBuilder<C, D> requireViewerContext(boolean requiresViewerContext) {
        return new PlaceholderBuilder<C, D>(this.contextTransformation, this.dataProviderFactory, this.typeToken, requiresViewerContext);
    }

    public <D2> PlaceholderBuilder<C, D2> transformData(Function<D, D2> dataTransformation, TypeToken<D2> typeToken) {
        return new PlaceholderBuilder<C, D>(this.contextTransformation, () -> this.dataProviderFactory.get().transformData(dataTransformation), typeToken, this.requiresViewerContext);
    }

    public TypeToken<D> getType() {
        return this.typeToken;
    }

    public Placeholder build() {
        return new GenericPlaceholder<C, D>(this.contextTransformation, this.dataProviderFactory, this.typeToken, this.requiresViewerContext);
    }

    public Function<Context, C> getContextTransformation() {
        return this.contextTransformation;
    }

    public Supplier<PlaceholderDataProvider<C, D>> getDataProviderFactory() {
        return this.dataProviderFactory;
    }

    public boolean isRequiresViewerContext() {
        return this.requiresViewerContext;
    }
}

