/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import java.util.List;
import java.util.stream.Collectors;

public abstract class PlaceholderArg {
    private PlaceholderArg() {
    }

    public abstract String getText();

    public abstract ExpressionTemplate getExpression();

    public static final class Complex
    extends PlaceholderArg {
        private final List<PlaceholderArg> value;

        @Override
        public String getText() {
            StringBuilder result = new StringBuilder();
            for (PlaceholderArg arg : this.value) {
                result.append(arg.getText());
            }
            return result.toString();
        }

        @Override
        public ExpressionTemplate getExpression() {
            return ExpressionTemplates.concat(this.value.stream().map(PlaceholderArg::getExpression).collect(Collectors.toList()));
        }

        public Complex(List<PlaceholderArg> value) {
            this.value = value;
        }

        public List<PlaceholderArg> getValue() {
            return this.value;
        }

        public String toString() {
            return "PlaceholderArg.Complex(value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Complex)) {
                return false;
            }
            Complex other = (Complex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PlaceholderArg> this$value = this.getValue();
            List<PlaceholderArg> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Complex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PlaceholderArg> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }
    }

    public static final class Placeholder
    extends PlaceholderArg {
        private final de.codecrafter47.taboverlay.config.placeholder.Placeholder value;
        private final String text;

        @Override
        public ExpressionTemplate getExpression() {
            return this.value;
        }

        public Placeholder(de.codecrafter47.taboverlay.config.placeholder.Placeholder value, String text) {
            this.value = value;
            this.text = text;
        }

        public de.codecrafter47.taboverlay.config.placeholder.Placeholder getValue() {
            return this.value;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public String toString() {
            return "PlaceholderArg.Placeholder(value=" + this.getValue() + ", text=" + this.getText() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder other = (Placeholder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            de.codecrafter47.taboverlay.config.placeholder.Placeholder this$value = this.getValue();
            de.codecrafter47.taboverlay.config.placeholder.Placeholder other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Placeholder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            de.codecrafter47.taboverlay.config.placeholder.Placeholder $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }
    }

    public static final class Text
    extends PlaceholderArg {
        private final String value;

        @Override
        public String getText() {
            return this.value;
        }

        @Override
        public ExpressionTemplate getExpression() {
            return ConstantExpressionTemplate.of(this.value);
        }

        public Text(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "PlaceholderArg.Text(value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Text;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

