/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.Conversions;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.placeholder.Placeholder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class GenericPlaceholder<C, D>
implements Placeholder {
    private Function<Context, C> contextTransformation;
    private TypeToken<D> typeToken;
    private Supplier<PlaceholderDataProvider<C, D>> dataProviderFactory;
    private boolean requiresViewerContext;

    GenericPlaceholder(Function<Context, C> contextTransformation, Supplier<PlaceholderDataProvider<C, D>> dataProviderFactory, TypeToken<D> typeToken, boolean requiresViewerContext) {
        this.contextTransformation = contextTransformation;
        this.dataProviderFactory = dataProviderFactory;
        this.typeToken = typeToken;
        this.requiresViewerContext = requiresViewerContext;
    }

    @Override
    @Nonnull
    public TextView instantiate() {
        return new GenericPlaceholderTextView();
    }

    @Override
    public ToStringExpression instantiateWithStringResult() {
        return new GenericPlaceholderToStringExpression();
    }

    @Override
    public ToDoubleExpression instantiateWithDoubleResult() {
        if (this.typeToken == TypeToken.FLOAT || this.typeToken == TypeToken.DOUBLE || this.typeToken == TypeToken.INTEGER) {
            return new GenericPlaceholderToDoubleExpression();
        }
        return Conversions.toDouble(this.instantiateWithStringResult());
    }

    @Override
    public ToBooleanExpression instantiateWithBooleanResult() {
        if (this.typeToken == TypeToken.BOOLEAN) {
            return new GenericPlaceholderToBooleanExpression();
        }
        return Conversions.toBoolean(this.instantiateWithStringResult());
    }

    @Override
    public boolean requiresViewerContext() {
        return this.requiresViewerContext;
    }

    private C transformContext(Context context) {
        return this.contextTransformation.apply(context);
    }

    private class GenericPlaceholderTextView
    extends AbstractActiveElement<TextViewUpdateListener>
    implements TextView,
    Runnable {
        private final PlaceholderDataProvider<C, D> delegate;

        private GenericPlaceholderTextView() {
            this.delegate = (PlaceholderDataProvider)GenericPlaceholder.this.dataProviderFactory.get();
        }

        @Override
        public String getText() {
            Object value = this.delegate.getData();
            if (value instanceof Float || value instanceof Double) {
                double val = ((Number)value).doubleValue();
                if (val % 1.0 == 0.0) {
                    return Integer.toString((int)val);
                }
                return String.format("%1.2f", val);
            }
            return value == null ? "" : Objects.toString(value);
        }

        @Override
        protected void onActivation() {
            this.delegate.activate(GenericPlaceholder.this.transformContext(this.getContext()), this);
        }

        @Override
        protected void onDeactivation() {
            this.delegate.deactivate();
        }

        @Override
        public void run() {
            if (this.hasListener()) {
                ((TextViewUpdateListener)this.getListener()).onTextUpdated();
            }
        }
    }

    private class GenericPlaceholderToStringExpression
    extends AbstractActiveElement<ExpressionUpdateListener>
    implements ToStringExpression,
    Runnable {
        private final PlaceholderDataProvider<C, D> delegate;

        private GenericPlaceholderToStringExpression() {
            this.delegate = (PlaceholderDataProvider)GenericPlaceholder.this.dataProviderFactory.get();
        }

        @Override
        public String evaluate() {
            Object value = this.delegate.getData();
            if (value instanceof Float || value instanceof Double) {
                double val = ((Number)value).doubleValue();
                if (val % 1.0 == 0.0) {
                    return Integer.toString((int)val);
                }
                return String.format("%1.2f", val);
            }
            return value == null ? "" : Objects.toString(value);
        }

        @Override
        protected void onActivation() {
            this.delegate.activate(GenericPlaceholder.this.transformContext(this.getContext()), this);
        }

        @Override
        protected void onDeactivation() {
            this.delegate.deactivate();
        }

        @Override
        public void run() {
            ((ExpressionUpdateListener)this.getListener()).onExpressionUpdate();
        }
    }

    private class GenericPlaceholderToDoubleExpression
    extends AbstractActiveElement<ExpressionUpdateListener>
    implements ToDoubleExpression,
    Runnable {
        private final PlaceholderDataProvider<C, D> delegate;

        private GenericPlaceholderToDoubleExpression() {
            this.delegate = (PlaceholderDataProvider)GenericPlaceholder.this.dataProviderFactory.get();
        }

        @Override
        public double evaluate() {
            Number value = (Number)this.delegate.getData();
            return value == null ? 0.0 : value.doubleValue();
        }

        @Override
        protected void onActivation() {
            this.delegate.activate(GenericPlaceholder.this.transformContext(this.getContext()), this);
        }

        @Override
        protected void onDeactivation() {
            this.delegate.deactivate();
        }

        @Override
        public void run() {
            ((ExpressionUpdateListener)this.getListener()).onExpressionUpdate();
        }
    }

    private class GenericPlaceholderToBooleanExpression
    extends AbstractActiveElement<ExpressionUpdateListener>
    implements ToBooleanExpression,
    Runnable {
        private final PlaceholderDataProvider<C, D> delegate;

        private GenericPlaceholderToBooleanExpression() {
            this.delegate = (PlaceholderDataProvider)GenericPlaceholder.this.dataProviderFactory.get();
        }

        @Override
        public boolean evaluate() {
            Boolean value = (Boolean)this.delegate.getData();
            return value == Boolean.TRUE;
        }

        @Override
        protected void onActivation() {
            this.delegate.activate(GenericPlaceholder.this.transformContext(this.getContext()), this);
        }

        @Override
        protected void onDeactivation() {
            this.delegate.deactivate();
        }

        @Override
        public void run() {
            ((ExpressionUpdateListener)this.getListener()).onExpressionUpdate();
        }
    }
}

