/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.data.api.DataHolder;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class DataHolderPlaceholderDataProviderSupplier<C extends DataHolder, R, T>
implements Supplier<PlaceholderDataProvider<C, T>> {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.ROOT);
    @Nonnull
    @NonNull
    private final TypeToken<T> type;
    @Nullable
    private final DataKey<R> dataKey;
    @Nonnull
    private final BiFunction<C, R, T> transformation;

    private T get(C context) {
        Object value = null;
        if (this.dataKey != null) {
            value = context.get(this.dataKey);
        }
        return this.transformation.apply(context, value);
    }

    public Function<C, String> getToStringFunction() {
        return context -> String.valueOf(this.get(context));
    }

    public ToDoubleFunction<C> getToDoubleFunction() {
        if (this.type == TypeToken.FLOAT || this.type == TypeToken.DOUBLE || this.type == TypeToken.INTEGER) {
            return context -> {
                Number value = (Number)this.get(context);
                return value == null ? 0.0 : value.doubleValue();
            };
        }
        if (this.type == TypeToken.BOOLEAN) {
            return context -> {
                Boolean bool = (Boolean)this.get(context);
                return bool == Boolean.TRUE ? 1.0 : 0.0;
            };
        }
        return context -> {
            String result = String.valueOf(this.get(context));
            try {
                return NUMBER_FORMAT.parse(result).doubleValue();
            }
            catch (NumberFormatException | ParseException ignored) {
                return 0.0;
            }
        };
    }

    @Override
    public PlaceholderDataProvider<C, T> get() {
        return new PlayerPlaceholderDataProvider();
    }

    public DataHolderPlaceholderDataProviderSupplier(@Nonnull @NonNull TypeToken<T> type, @Nullable DataKey<R> dataKey, @Nonnull BiFunction<C, R, T> transformation) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (transformation == null) {
            throw new NullPointerException("transformation is marked non-null but is null");
        }
        this.type = type;
        this.dataKey = dataKey;
        this.transformation = transformation;
    }

    @Nonnull
    @NonNull
    public TypeToken<T> getType() {
        return this.type;
    }

    @Nullable
    public DataKey<R> getDataKey() {
        return this.dataKey;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }

    private class PlayerPlaceholderDataProvider
    implements PlaceholderDataProvider<C, T> {
        private C context;
        private Runnable listener;

        private PlayerPlaceholderDataProvider() {
        }

        @Override
        public void activate(C player, Runnable listener) {
            this.context = player;
            this.listener = listener;
            if (DataHolderPlaceholderDataProviderSupplier.this.dataKey != null) {
                player.addDataChangeListener(DataHolderPlaceholderDataProviderSupplier.this.dataKey, listener);
            }
        }

        @Override
        public void deactivate() {
            if (DataHolderPlaceholderDataProviderSupplier.this.dataKey != null) {
                this.context.removeDataChangeListener(DataHolderPlaceholderDataProviderSupplier.this.dataKey, this.listener);
            }
        }

        @Override
        public T getData() {
            return DataHolderPlaceholderDataProviderSupplier.this.get(this.context);
        }
    }
}

