/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.Map;
import java.util.concurrent.Future;

public class CustomPlaceholderSwitch
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
ExpressionUpdateListener,
TextViewUpdateListener {
    private final ToStringExpression expression;
    private final Map<String, TextTemplate> replacements;
    private final TextTemplate defaultReplacement;
    private TextView activeView;
    private Future<?> updateFuture = null;

    public CustomPlaceholderSwitch(ExpressionTemplate expression, Map<String, TextTemplate> replacements, TextTemplate defaultReplacement) {
        this.expression = expression.instantiateWithStringResult();
        this.replacements = replacements;
        this.defaultReplacement = defaultReplacement;
    }

    private void update(boolean fireEvent) {
        if (!this.isActive()) {
            return;
        }
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        String result = this.expression.evaluate();
        TextTemplate template = this.replacements.getOrDefault(result, this.defaultReplacement);
        this.activeView = template.instantiate();
        this.activeView.activate(this.getContext(), this);
        if (fireEvent && this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    protected void onActivation() {
        this.expression.activate(this.getContext(), this);
        this.update(false);
    }

    @Override
    protected void onDeactivation() {
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        this.expression.deactivate();
    }

    @Override
    public void onExpressionUpdate() {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(() -> this.update(true));
        }
    }

    @Override
    public void onTextUpdated() {
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    public String getData() {
        return this.activeView.getText();
    }
}

