/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class CustomPlaceholderSelect
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
ExpressionUpdateListener,
TextViewUpdateListener {
    private final List<SelectEntry> entryList;
    private final TextTemplate defaultReplacement;
    private TextView activeView;
    private int activeEntry = -1;
    private Future<?> updateFuture = null;

    public CustomPlaceholderSelect(Map<ExpressionTemplate, TextTemplate> replacements, TextTemplate defaultReplacement) {
        this.entryList = new ArrayList<SelectEntry>(replacements.size());
        for (Map.Entry<ExpressionTemplate, TextTemplate> entry : replacements.entrySet()) {
            this.entryList.add(new SelectEntry(entry.getKey().instantiateWithBooleanResult(), entry.getValue()));
        }
        this.defaultReplacement = defaultReplacement;
    }

    private void update(boolean fireEvent) {
        int i;
        if (!this.isActive()) {
            return;
        }
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        for (i = 0; i < this.entryList.size(); ++i) {
            ToBooleanExpression expression = this.entryList.get(i).getExpression();
            if (i > this.activeEntry) {
                expression.activate(this.getContext(), this);
            }
            if (expression.evaluate()) break;
        }
        for (int j = i + 1; j <= this.activeEntry && j < this.entryList.size(); ++j) {
            this.entryList.get(j).getExpression().deactivate();
        }
        this.activeEntry = i;
        TextTemplate template = i < this.entryList.size() ? this.entryList.get(i).getReplacement() : this.defaultReplacement;
        this.activeView = template.instantiate();
        this.activeView.activate(this.getContext(), this);
        if (fireEvent && this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    protected void onActivation() {
        this.activeEntry = -1;
        this.update(false);
    }

    @Override
    protected void onDeactivation() {
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        for (int j = 0; j <= this.activeEntry && j < this.entryList.size(); ++j) {
            this.entryList.get(j).getExpression().deactivate();
        }
        this.activeEntry = -1;
    }

    @Override
    public void onExpressionUpdate() {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(() -> this.update(true));
        }
    }

    @Override
    public void onTextUpdated() {
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    public String getData() {
        return this.activeView.getText();
    }

    private static final class SelectEntry {
        private final ToBooleanExpression expression;
        private final TextTemplate replacement;

        public SelectEntry(ToBooleanExpression expression, TextTemplate replacement) {
            this.expression = expression;
            this.replacement = replacement;
        }

        public ToBooleanExpression getExpression() {
            return this.expression;
        }

        public TextTemplate getReplacement() {
            return this.replacement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectEntry)) {
                return false;
            }
            SelectEntry other = (SelectEntry)o;
            ToBooleanExpression this$expression = this.getExpression();
            ToBooleanExpression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            TextTemplate this$replacement = this.getReplacement();
            TextTemplate other$replacement = other.getReplacement();
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ToBooleanExpression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            TextTemplate $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }

        public String toString() {
            return "CustomPlaceholderSelect.SelectEntry(expression=" + this.getExpression() + ", replacement=" + this.getReplacement() + ")";
        }
    }
}

