/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class CustomPlaceholderResolver
implements PlaceholderResolver<Context> {
    private final Map<String, CustomPlaceholderConfiguration> customPlaceholderMap;

    public CustomPlaceholderResolver(Map<String, CustomPlaceholderConfiguration> customPlaceholderMap) {
        this.customPlaceholderMap = customPlaceholderMap;
    }

    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() >= 1 && args.get(0) instanceof PlaceholderArg.Text) {
            String placeholderId = ((PlaceholderArg.Text)args.get(0)).getValue();
            CustomPlaceholderConfiguration customPlaceholder = this.customPlaceholderMap.get(placeholderId);
            if (customPlaceholder == null) {
                throw new UnknownPlaceholderException();
            }
            if (tcc.hasVisitedCustomPlaceholder(placeholderId)) {
                throw new PlaceholderException("Custom placeholder recursion");
            }
            TemplateCreationContext childContext = tcc.clone();
            childContext.visitCustomPlaceholder(placeholderId);
            args.remove(0);
            PlaceholderBuilder<?, ?> result = customPlaceholder.bindArgs(builder, args, childContext);
            if (customPlaceholder.getParameters().getValue() != 0) {
                args.clear();
            }
            return result;
        }
        throw new UnknownPlaceholderException();
    }
}

