/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.context.ContextKeys;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class CustomPlaceholderProgressBar
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
ExpressionUpdateListener {
    private final ToDoubleExpression value;
    private final ExpressionTemplate valueTemplate;
    private final ToDoubleExpression minValue;
    private final ExpressionTemplate minValueTemplate;
    private final ToDoubleExpression maxValue;
    private final ExpressionTemplate maxValueTemplate;
    private final ExpressionTemplate percentageTemplate;
    private final int symbolCount;
    private final String symbolCompleted;
    private final String symbolRemaining;
    private final List<String> symbolsCurrent;
    private final TextView borderLeft;
    private final TextView borderRight;
    private final BarRenderer regularBarRenderer;
    private final BarRenderer emptyBarRenderer;
    private final BarRenderer fullBarRenderer;
    private BarRenderer activeBarRenderer;
    private String bar;

    public CustomPlaceholderProgressBar(ExpressionTemplate valueTemplate, ExpressionTemplate minValueTemplate, ExpressionTemplate maxValueTemplate, int symbolCount, String symbolCompleted, String symbolRemaining, List<String> symbolsCurrent, TextTemplate borderLeftTemplate, TextTemplate borderRightTemplate, TextTemplate textCenterTemplate, TextTemplate textCenterEmptyTemplate, TextTemplate textCenterFullTemplate, BarColor colorCompleted, @Nullable TextColor colorCurrent, boolean colorCurrentInterpolate, BarColor colorRemaining, TextColor colorEmptyBar, TextColor colorFullBar, boolean emptyBarShowSymbols, boolean fullBarShowSymbols, TextTemplate emptyBarTemplate, TextTemplate fullBarTemplate) {
        TextTemplate textCenterTemplate1;
        BarColor colorRemaining1;
        boolean colorCurrentInterpolate1;
        TextColor colorCurrent1;
        BarColor colorCompleted1;
        this.value = valueTemplate.instantiateWithDoubleResult();
        this.valueTemplate = valueTemplate;
        this.minValue = minValueTemplate.instantiateWithDoubleResult();
        this.minValueTemplate = minValueTemplate;
        this.maxValue = maxValueTemplate.instantiateWithDoubleResult();
        this.maxValueTemplate = maxValueTemplate;
        this.percentageTemplate = ExpressionTemplates.product(Arrays.asList(ExpressionTemplates.div(ExpressionTemplates.sub(valueTemplate, minValueTemplate), ExpressionTemplates.sub(maxValueTemplate, minValueTemplate)), ConstantExpressionTemplate.of(100.0)));
        this.symbolCount = symbolCount;
        this.symbolCompleted = symbolCompleted;
        this.symbolRemaining = symbolRemaining;
        this.symbolsCurrent = symbolsCurrent;
        this.borderLeft = borderLeftTemplate.instantiate();
        this.borderRight = borderRightTemplate.instantiate();
        double symbolLength = ChatFormat.formattedTextLength(symbolCompleted);
        this.regularBarRenderer = textCenterTemplate == null ? new PlainBarRenderer(colorCompleted, colorCurrent, colorCurrentInterpolate, colorRemaining) : new CenterTextBarRenderer(colorCompleted, colorCurrent, colorCurrentInterpolate, colorRemaining, textCenterTemplate.instantiate(), symbolLength * (double)symbolCount);
        if (emptyBarTemplate != null) {
            this.emptyBarRenderer = new TextViewBarRenderer(emptyBarTemplate.instantiate());
        } else if (colorEmptyBar != null || textCenterEmptyTemplate != null || !emptyBarShowSymbols) {
            colorCompleted1 = colorEmptyBar == null ? colorCompleted : new ConstantBarColor(colorEmptyBar);
            colorCurrent1 = colorEmptyBar == null ? colorCurrent : colorEmptyBar;
            colorCurrentInterpolate1 = colorEmptyBar == null ? colorCurrentInterpolate : false;
            BarColor barColor = colorRemaining1 = colorEmptyBar == null ? colorRemaining : new ConstantBarColor(colorEmptyBar);
            if (textCenterEmptyTemplate == null && textCenterTemplate == null && emptyBarShowSymbols) {
                this.emptyBarRenderer = new PlainBarRenderer(colorCompleted1, colorCurrent1, colorCurrentInterpolate1, colorRemaining1);
            } else {
                textCenterTemplate1 = textCenterEmptyTemplate != null ? textCenterEmptyTemplate : (textCenterTemplate != null ? textCenterTemplate : TextTemplate.EMPTY);
                this.emptyBarRenderer = new CenterTextBarRenderer(colorCompleted1, colorCurrent1, colorCurrentInterpolate1, colorRemaining1, textCenterTemplate1.instantiate(), symbolLength * (double)symbolCount);
            }
        } else {
            this.emptyBarRenderer = this.regularBarRenderer;
        }
        if (fullBarTemplate != null) {
            this.fullBarRenderer = new TextViewBarRenderer(fullBarTemplate.instantiate());
        } else if (colorFullBar != null || textCenterFullTemplate != null || !fullBarShowSymbols) {
            colorCompleted1 = colorFullBar == null ? colorCompleted : new ConstantBarColor(colorFullBar);
            colorCurrent1 = colorFullBar == null ? colorCurrent : colorFullBar;
            colorCurrentInterpolate1 = colorFullBar == null ? colorCurrentInterpolate : false;
            BarColor barColor = colorRemaining1 = colorFullBar == null ? colorRemaining : new ConstantBarColor(colorFullBar);
            if (textCenterFullTemplate == null && textCenterTemplate == null && fullBarShowSymbols) {
                this.fullBarRenderer = new PlainBarRenderer(colorCompleted1, colorCurrent1, colorCurrentInterpolate1, colorRemaining1);
            } else {
                textCenterTemplate1 = textCenterFullTemplate != null ? textCenterFullTemplate : (textCenterTemplate != null ? textCenterTemplate : TextTemplate.EMPTY);
                this.fullBarRenderer = new CenterTextBarRenderer(colorCompleted1, colorCurrent1, colorCurrentInterpolate1, colorRemaining1, textCenterTemplate1.instantiate(), symbolLength * (double)symbolCount);
            }
        } else {
            this.fullBarRenderer = this.regularBarRenderer;
        }
    }

    @Override
    public String getData() {
        return this.bar;
    }

    @Override
    protected void onActivation() {
        this.value.activate(this.getContext(), this);
        this.minValue.activate(this.getContext(), this);
        this.maxValue.activate(this.getContext(), this);
        this.updateActiveBarRenderer();
        this.renderBar();
    }

    @Override
    protected void onDeactivation() {
        this.value.deactivate();
        this.minValue.deactivate();
        this.maxValue.deactivate();
        this.activeBarRenderer.deactivate();
        this.activeBarRenderer = null;
    }

    @Override
    public void onExpressionUpdate() {
        this.updateActiveBarRenderer();
        this.renderBar();
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateActiveBarRenderer() {
        BarRenderer renderer = this.regularBarRenderer;
        double value = this.value.evaluate();
        if (value <= this.minValue.evaluate()) {
            renderer = this.emptyBarRenderer;
        }
        if (value >= this.maxValue.evaluate()) {
            renderer = this.fullBarRenderer;
        }
        if (renderer != this.activeBarRenderer) {
            if (this.activeBarRenderer != null) {
                this.activeBarRenderer.deactivate();
            }
            this.activeBarRenderer = renderer;
            this.activeBarRenderer.activate();
        }
    }

    private void renderBar() {
        this.bar = this.activeBarRenderer.render(this.value.evaluate(), this.minValue.evaluate(), this.maxValue.evaluate());
    }

    private Context prepareBarContext() {
        Context context = this.getContext().clone();
        context.setCustomObject(ContextKeys.BAR_VALUE, this.valueTemplate);
        context.setCustomObject(ContextKeys.BAR_PERCENTAGE, this.percentageTemplate);
        context.setCustomObject(ContextKeys.BAR_MIN_VALUE, this.minValueTemplate);
        context.setCustomObject(ContextKeys.BAR_MAX_VALUE, this.maxValueTemplate);
        return context;
    }

    private class PlainBarRenderer
    implements BarRenderer,
    TextViewUpdateListener {
        private final BarColor colorCompleted;
        @Nullable
        private final TextColor colorCurrent;
        private final boolean colorCurrentInterpolate;
        private final BarColor colorRemaining;

        public PlainBarRenderer(@Nullable BarColor colorCompleted, TextColor colorCurrent, boolean colorCurrentInterpolate, BarColor colorRemaining) {
            this.colorCompleted = colorCompleted;
            this.colorCurrent = colorCurrent;
            this.colorCurrentInterpolate = colorCurrentInterpolate;
            this.colorRemaining = colorRemaining;
        }

        @Override
        public String render(double value, double minValue, double maxValue) {
            int i;
            double p = (value - minValue) / (maxValue - minValue);
            int idxCurrent = (int)(p * (double)CustomPlaceholderProgressBar.this.symbolCount);
            if (p <= 0.0) {
                idxCurrent = -1;
            }
            if (p >= 1.0) {
                idxCurrent = CustomPlaceholderProgressBar.this.symbolCount;
            }
            StringBuilder sb = new StringBuilder(CustomPlaceholderProgressBar.this.bar != null ? CustomPlaceholderProgressBar.this.bar.length() : 64);
            sb.append(CustomPlaceholderProgressBar.this.borderLeft.getText());
            for (i = 0; i < idxCurrent && i < CustomPlaceholderProgressBar.this.symbolCount; ++i) {
                sb.append(this.colorCompleted.getFormat((float)i / (float)CustomPlaceholderProgressBar.this.symbolCount).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolCompleted);
            }
            if (i < CustomPlaceholderProgressBar.this.symbolCount && i == idxCurrent) {
                double pi = p * (double)CustomPlaceholderProgressBar.this.symbolCount - (double)i;
                if (this.colorCurrentInterpolate) {
                    sb.append(TextColor.interpolateLinear(this.colorRemaining.getFormat(p), this.colorCompleted.getFormat(p), pi).getFormatCode());
                } else if (this.colorCurrent != null) {
                    sb.append(this.colorCurrent.getFormatCode());
                } else {
                    sb.append(this.colorCompleted.getFormat(p).getFormatCode());
                }
                int si = (int)(pi * (double)CustomPlaceholderProgressBar.this.symbolsCurrent.size());
                if (si < 0) {
                    si = 0;
                } else if (si >= CustomPlaceholderProgressBar.this.symbolsCurrent.size()) {
                    si = CustomPlaceholderProgressBar.this.symbolsCurrent.size() - 1;
                }
                sb.append((String)CustomPlaceholderProgressBar.this.symbolsCurrent.get(si));
                ++i;
            }
            while (i < CustomPlaceholderProgressBar.this.symbolCount) {
                sb.append(this.colorRemaining.getFormat((float)i / (float)CustomPlaceholderProgressBar.this.symbolCount).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolRemaining);
                ++i;
            }
            sb.append("&r");
            sb.append(CustomPlaceholderProgressBar.this.borderRight.getText());
            return sb.toString();
        }

        @Override
        public void activate() {
            Context context = CustomPlaceholderProgressBar.this.prepareBarContext();
            CustomPlaceholderProgressBar.this.borderLeft.activate(context, this);
            CustomPlaceholderProgressBar.this.borderRight.activate(context, this);
        }

        @Override
        public void deactivate() {
            CustomPlaceholderProgressBar.this.borderLeft.deactivate();
            CustomPlaceholderProgressBar.this.borderRight.deactivate();
        }

        @Override
        public void onTextUpdated() {
            CustomPlaceholderProgressBar.this.renderBar();
            CustomPlaceholderProgressBar.this.notifyListeners();
        }
    }

    public static interface BarColor {
        public static final BarColor NONE = new BarColor(){

            @Override
            public TextColor getFormat(double progress) {
                return TextColor.COLOR_WHITE;
            }
        };

        public TextColor getFormat(double var1);
    }

    private static interface BarRenderer {
        public String render(double var1, double var3, double var5);

        public void activate();

        public void deactivate();
    }

    private class CenterTextBarRenderer
    implements BarRenderer,
    TextViewUpdateListener {
        private final BarColor colorCompleted;
        @Nullable
        private final TextColor colorCurrent;
        private final boolean colorCurrentInterpolate;
        private final BarColor colorRemaining;
        private final TextView centerText;
        private final double length;

        public CenterTextBarRenderer(@Nullable BarColor colorCompleted, TextColor colorCurrent, boolean colorCurrentInterpolate, BarColor colorRemaining, TextView centerText, double length) {
            this.colorCompleted = colorCompleted;
            this.colorCurrent = colorCurrent;
            this.colorCurrentInterpolate = colorCurrentInterpolate;
            this.colorRemaining = colorRemaining;
            this.centerText = centerText;
            this.length = length;
        }

        @Override
        public String render(double value, double minValue, double maxValue) {
            double pi;
            String text = this.centerText.getText();
            double textLength = ChatFormat.formattedTextLength(text);
            double symbolLength = ChatFormat.formattedTextLength(CustomPlaceholderProgressBar.this.symbolCompleted);
            int symbolCountLeft = (int)((this.length - textLength) / symbolLength / 2.0);
            int symbolCountRight = (int)((this.length - textLength - (double)symbolCountLeft * symbolLength) / symbolLength);
            text = text + ChatFormat.stripFormat(ChatFormat.createSpacesExact((float)(this.length - textLength - (double)(symbolCountLeft + symbolCountRight) * symbolLength)));
            if (symbolCountLeft < 0) {
                symbolCountLeft = 0;
            }
            if (symbolCountRight < 0) {
                symbolCountRight = 0;
            }
            double p = (value - minValue) / (maxValue - minValue);
            int idxCurrent = (int)(p * this.length);
            if (p <= 0.0) {
                idxCurrent = -1;
            }
            if (p >= 1.0) {
                idxCurrent = (int)this.length;
            }
            StringBuilder sb = new StringBuilder(CustomPlaceholderProgressBar.this.bar != null ? CustomPlaceholderProgressBar.this.bar.length() : 64);
            sb.append(CustomPlaceholderProgressBar.this.borderLeft.getText());
            int i = 0;
            double l = 0.0;
            while ((double)idxCurrent >= l + symbolLength && i < symbolCountLeft) {
                sb.append(this.colorCompleted.getFormat(l / this.length).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolCompleted);
                ++i;
                l += symbolLength;
            }
            if (i < symbolCountLeft && (double)idxCurrent >= l && (double)idxCurrent < l + symbolLength) {
                double pi2 = p * (double)CustomPlaceholderProgressBar.this.symbolCount - (double)i;
                if (this.colorCurrentInterpolate) {
                    sb.append(TextColor.interpolateLinear(this.colorRemaining.getFormat(p), this.colorCompleted.getFormat(p), pi2).getFormatCode());
                } else if (this.colorCurrent != null) {
                    sb.append(this.colorCurrent.getFormatCode());
                } else {
                    sb.append(this.colorCompleted.getFormat(p).getFormatCode());
                }
                int si = (int)pi2;
                if (si < 0) {
                    si = 0;
                } else if (si >= CustomPlaceholderProgressBar.this.symbolsCurrent.size()) {
                    si = CustomPlaceholderProgressBar.this.symbolsCurrent.size() - 1;
                }
                sb.append((String)CustomPlaceholderProgressBar.this.symbolsCurrent.get(si));
                ++i;
                l += symbolLength;
            }
            while (i < symbolCountLeft) {
                sb.append(this.colorRemaining.getFormat(l / this.length).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolRemaining);
                ++i;
                l += symbolLength;
            }
            sb.append("&r");
            i = 0;
            while (i < text.length()) {
                int n;
                int c = text.codePointAt(i);
                if (!((double)idxCurrent >= l + ChatFormat.getCharWidth(n))) break;
                sb.append(this.colorCompleted.getFormat(l / this.length).getFormatCode());
                sb.appendCodePoint(c);
                i += Character.charCount(c);
                l += ChatFormat.getCharWidth(c);
            }
            if (i < text.length() && l <= (double)idxCurrent) {
                int n;
                int c = text.codePointAt(i);
                if (l + symbolLength > ChatFormat.getCharWidth(n)) {
                    pi = (p * this.length - l) / ChatFormat.getCharWidth(c);
                    if (this.colorCurrentInterpolate) {
                        sb.append(TextColor.interpolateLinear(this.colorRemaining.getFormat(p), this.colorCompleted.getFormat(p), pi).getFormatCode());
                    } else if (this.colorCurrent != null) {
                        sb.append(this.colorCurrent.getFormatCode());
                    } else {
                        sb.append(this.colorCompleted.getFormat(p).getFormatCode());
                    }
                    sb.appendCodePoint(c);
                    ++i;
                    l += ChatFormat.getCharWidth(c);
                }
            }
            while (i < text.length()) {
                int c = text.codePointAt(i);
                sb.append(this.colorRemaining.getFormat(l / this.length).getFormatCode());
                sb.appendCodePoint(c);
                i += Character.charCount(c);
                l += ChatFormat.getCharWidth(c);
            }
            sb.append("&r");
            i = CustomPlaceholderProgressBar.this.symbolCount - symbolCountRight;
            while ((double)idxCurrent >= l + symbolLength && i < CustomPlaceholderProgressBar.this.symbolCount) {
                sb.append(this.colorCompleted.getFormat(l / this.length).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolCompleted);
                ++i;
                l += symbolLength;
            }
            if (i < CustomPlaceholderProgressBar.this.symbolCount && l <= (double)idxCurrent && l + symbolLength > (double)idxCurrent) {
                pi = p * (double)CustomPlaceholderProgressBar.this.symbolCount - (double)i;
                if (this.colorCurrentInterpolate) {
                    sb.append(TextColor.interpolateLinear(this.colorRemaining.getFormat(p), this.colorCompleted.getFormat(p), pi).getFormatCode());
                } else if (this.colorCurrent != null) {
                    sb.append(this.colorCurrent.getFormatCode());
                } else {
                    sb.append(this.colorCompleted.getFormat(p).getFormatCode());
                }
                int si = (int)pi;
                if (si < 0) {
                    si = 0;
                } else if (si >= CustomPlaceholderProgressBar.this.symbolsCurrent.size()) {
                    si = CustomPlaceholderProgressBar.this.symbolsCurrent.size() - 1;
                }
                sb.append((String)CustomPlaceholderProgressBar.this.symbolsCurrent.get(si));
                ++i;
                l += symbolLength;
            }
            while (i < CustomPlaceholderProgressBar.this.symbolCount) {
                sb.append(this.colorRemaining.getFormat(l / this.length).getFormatCode());
                sb.append(CustomPlaceholderProgressBar.this.symbolRemaining);
                ++i;
                l += symbolLength;
            }
            sb.append("&r");
            sb.append(CustomPlaceholderProgressBar.this.borderRight.getText());
            return sb.toString();
        }

        @Override
        public void activate() {
            Context context = CustomPlaceholderProgressBar.this.prepareBarContext();
            CustomPlaceholderProgressBar.this.borderLeft.activate(context, this);
            CustomPlaceholderProgressBar.this.borderRight.activate(context, this);
            this.centerText.activate(context, this);
        }

        @Override
        public void deactivate() {
            CustomPlaceholderProgressBar.this.borderLeft.deactivate();
            CustomPlaceholderProgressBar.this.borderRight.deactivate();
            this.centerText.deactivate();
        }

        @Override
        public void onTextUpdated() {
            CustomPlaceholderProgressBar.this.renderBar();
            CustomPlaceholderProgressBar.this.notifyListeners();
        }
    }

    private class TextViewBarRenderer
    implements BarRenderer,
    TextViewUpdateListener {
        private final TextView textView;

        private TextViewBarRenderer(TextView textView) {
            this.textView = textView;
        }

        @Override
        public String render(double value, double minValue, double maxValue) {
            return this.textView.getText();
        }

        @Override
        public void activate() {
            Context context = CustomPlaceholderProgressBar.this.prepareBarContext();
            this.textView.activate(context, this);
        }

        @Override
        public void deactivate() {
            this.textView.deactivate();
        }

        @Override
        public void onTextUpdated() {
            CustomPlaceholderProgressBar.this.renderBar();
            CustomPlaceholderProgressBar.this.notifyListeners();
        }
    }

    public static class ConstantBarColor
    implements BarColor {
        private final TextColor color;

        @Override
        public TextColor getFormat(double progress) {
            return this.color;
        }

        public ConstantBarColor(TextColor color) {
            this.color = color;
        }
    }

    public static class DarkerBarColor
    implements BarColor {
        private BarColor other;

        @Override
        public TextColor getFormat(double progress) {
            TextColor color = this.other.getFormat(progress);
            return new TextColor(color.getR() / 2, color.getG() / 2, color.getB() / 2);
        }

        public DarkerBarColor(BarColor other) {
            this.other = other;
        }
    }

    public static class InterpolateBarColor
    implements BarColor {
        int[] colorCompletedSteps;
        TextColor[] colorCompletedColors;

        @Override
        public TextColor getFormat(double progress) {
            int p = (int)(progress * 100.0);
            int i = Arrays.binarySearch(this.colorCompletedSteps, p);
            if (i < 0) {
                i = -i - 2;
            }
            if (i < 0) {
                return this.colorCompletedColors[0];
            }
            if (i >= this.colorCompletedSteps.length - 1) {
                return this.colorCompletedColors[this.colorCompletedSteps.length - 1];
            }
            return TextColor.interpolateSine(this.colorCompletedColors[i], this.colorCompletedColors[i + 1], (progress * 100.0 - (double)this.colorCompletedSteps[i]) / (double)(this.colorCompletedSteps[i + 1] - this.colorCompletedSteps[i]));
        }

        public InterpolateBarColor(int[] colorCompletedSteps, TextColor[] colorCompletedColors) {
            this.colorCompletedSteps = colorCompletedSteps;
            this.colorCompletedColors = colorCompletedColors;
        }
    }

    public static class StepBarColor
    implements BarColor {
        int[] colorCompletedSteps;
        TextColor[] colorCompletedColors;

        @Override
        public TextColor getFormat(double progress) {
            int p = (int)(progress * 100.0);
            int i = Arrays.binarySearch(this.colorCompletedSteps, p);
            if (i < 0) {
                i = -i - 2;
            }
            if (i < 0) {
                i = 0;
            }
            if (i >= this.colorCompletedSteps.length) {
                i = this.colorCompletedSteps.length - 1;
            }
            return this.colorCompletedColors[i];
        }

        public StepBarColor(int[] colorCompletedSteps, TextColor[] colorCompletedColors) {
            this.colorCompletedSteps = colorCompletedSteps;
            this.colorCompletedColors = colorCompletedColors;
        }
    }
}

