/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.concurrent.Future;

public class CustomPlaceholderConditional
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
ExpressionUpdateListener,
TextViewUpdateListener {
    private final ToBooleanExpression condition;
    private final TextTemplate trueReplacement;
    private final TextTemplate falseReplacement;
    private TextView activeReplacement;
    private Future<?> updateFuture = null;

    public CustomPlaceholderConditional(ExpressionTemplate condition, TextTemplate trueReplacement, TextTemplate falseReplacement) {
        this.condition = condition.instantiateWithBooleanResult();
        this.trueReplacement = trueReplacement;
        this.falseReplacement = falseReplacement;
    }

    @Override
    protected void onActivation() {
        this.condition.activate(this.getContext(), this);
        this.update(false);
    }

    private void update(boolean fireEvent) {
        boolean result;
        if (!this.isActive()) {
            return;
        }
        if (this.activeReplacement != null) {
            this.activeReplacement.deactivate();
        }
        this.activeReplacement = (result = this.condition.evaluate()) ? this.trueReplacement.instantiate() : this.falseReplacement.instantiate();
        this.activeReplacement.activate(this.getContext(), this);
        if (fireEvent && this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    protected void onDeactivation() {
        if (this.activeReplacement != null) {
            this.activeReplacement.deactivate();
        }
        this.condition.deactivate();
    }

    @Override
    public void onExpressionUpdate() {
        if (this.updateFuture == null || this.updateFuture.isDone()) {
            this.updateFuture = this.getContext().getTabEventQueue().submit(() -> this.update(true));
        }
    }

    @Override
    public void onTextUpdated() {
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    public String getData() {
        return this.activeReplacement.getText();
    }
}

