/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CustomPlaceholderColorAnimationWaveCenter
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private static final float PULSE_RADIUS = 10.0f;
    private Future<?> task;
    private final TextView textView;
    private final TextColor baseColor;
    private final TextColor effectColor;
    private final float speed;
    private final String formats;
    private String text;
    private float pos = 0.0f;
    private float period;
    private String replacement;
    private float textLength;

    public CustomPlaceholderColorAnimationWaveCenter(TextTemplate textTemplate, TextColor baseColor, TextColor effectColor, float speed, String formats) {
        this.textView = textTemplate.instantiate();
        this.baseColor = baseColor;
        this.effectColor = effectColor;
        this.speed = speed;
        this.formats = formats;
    }

    void updateText() {
        this.text = ChatFormat.stripFormat(this.textView.getText());
        this.textLength = ChatFormat.formattedTextLength(this.text);
        this.period = Float.max(this.textLength * 1.5f, this.textLength / 2.0f + 20.0f);
        this.updateReplacement();
    }

    void updateAnimation() {
        this.updateReplacement();
        this.pos += this.speed;
        if (this.pos < -10.0f) {
            this.pos += this.period;
        }
        if (this.pos > this.period - 10.0f) {
            this.pos -= this.period;
        }
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateReplacement() {
        TextColor color;
        double factor;
        int i;
        StringBuilder sb = new StringBuilder(this.text.length() * (9 + this.formats.length()));
        float halfTextLength = this.textLength / 2.0f;
        float pos = halfTextLength - this.pos;
        float min = pos - 10.0f;
        float max = pos + 10.0f;
        double d = 0.0;
        boolean hasBaseColor = false;
        for (i = 0; i < this.text.length() && d <= (double)halfTextLength; d += ChatFormat.getCharWidth(this.text.codePointAt(i)), i += Character.charCount(this.text.codePointAt(i))) {
            if (d > (double)min && d < (double)max) {
                factor = Math.abs(d - (double)pos) / 10.0;
                color = TextColor.interpolateSine(this.effectColor, this.baseColor, factor);
                sb.append(color.getFormatCode());
                hasBaseColor = false;
            } else if (!hasBaseColor) {
                sb.append(this.baseColor.getFormatCode());
                hasBaseColor = true;
            }
            sb.append(this.formats);
            sb.appendCodePoint(this.text.codePointAt(i));
        }
        pos = halfTextLength + this.pos;
        min = pos - 10.0f;
        max = pos + 10.0f;
        while (i < this.text.length()) {
            if (d > (double)min && d < (double)max) {
                factor = Math.abs(d - (double)pos) / 10.0;
                color = TextColor.interpolateSine(this.effectColor, this.baseColor, factor);
                sb.append(color.getFormatCode());
                hasBaseColor = false;
            } else if (!hasBaseColor) {
                sb.append(this.baseColor.getFormatCode());
                hasBaseColor = true;
            }
            sb.append(this.formats);
            sb.appendCodePoint(this.text.codePointAt(i));
            d += ChatFormat.getCharWidth(this.text.codePointAt(i));
            i += Character.charCount(this.text.codePointAt(i));
        }
        this.replacement = sb.toString();
    }

    @Override
    public String getData() {
        return this.replacement;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this);
        this.updateText();
        if (this.speed != 0.0f) {
            this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::updateAnimation, 100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onDeactivation() {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.textView.deactivate();
    }

    @Override
    public void onTextUpdated() {
        this.updateText();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

