/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CustomPlaceholderColorAnimationWave
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private static final float PULSE_RADIUS = 10.0f;
    private Future<?> task;
    private final TextView textView;
    private final TextColor baseColor;
    private final TextColor effectColor;
    private final float speed;
    private final String formats;
    private String text;
    private float pos = 0.0f;
    private float period;
    private String replacement;

    public CustomPlaceholderColorAnimationWave(TextTemplate textTemplate, TextColor baseColor, TextColor effectColor, float speed, String formats) {
        this.textView = textTemplate.instantiate();
        this.baseColor = baseColor;
        this.effectColor = effectColor;
        this.speed = speed;
        this.formats = formats;
    }

    void updateText() {
        this.text = ChatFormat.stripFormat(this.textView.getText());
        float textLength = ChatFormat.formattedTextLength(this.text);
        this.period = Float.max(textLength * 2.5f, textLength + 20.0f);
        this.updateReplacement();
    }

    void updateAnimation() {
        this.updateReplacement();
        this.pos += this.speed;
        if (this.pos < -10.0f) {
            this.pos += this.period;
        }
        if (this.pos > this.period - 10.0f) {
            this.pos -= this.period;
        }
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateReplacement() {
        StringBuilder sb = new StringBuilder(this.text.length() * (9 + this.formats.length()));
        float min = this.pos - 10.0f;
        float max = this.pos + 10.0f;
        double d = 0.0;
        boolean hasBaseColor = false;
        for (int i = 0; i < this.text.length(); i += Character.charCount(this.text.codePointAt(i))) {
            if (d > (double)min && d < (double)max) {
                double factor = Math.abs(d - (double)this.pos) / 10.0;
                TextColor color = TextColor.interpolateSine(this.effectColor, this.baseColor, factor);
                sb.append(color.getFormatCode());
                sb.append(this.formats);
                hasBaseColor = false;
            } else if (!hasBaseColor) {
                sb.append(this.baseColor.getFormatCode());
                sb.append(this.formats);
                hasBaseColor = true;
            }
            sb.appendCodePoint(this.text.codePointAt(i));
            d += ChatFormat.getCharWidth(this.text.codePointAt(i));
        }
        this.replacement = sb.toString();
    }

    @Override
    public String getData() {
        return this.replacement;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this);
        this.updateText();
        if (this.speed != 0.0f) {
            this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::updateAnimation, 100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onDeactivation() {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.textView.deactivate();
    }

    @Override
    public void onTextUpdated() {
        this.updateText();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

