/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CustomPlaceholderColorAnimationRandom
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private Future<?> task;
    private final TextView textView;
    private final List<TextColor> colors;
    private final String formats;
    private String text;
    private String replacement;

    public CustomPlaceholderColorAnimationRandom(TextTemplate textTemplate, List<TextColor> colors, String formats) {
        this.textView = textTemplate.instantiate();
        this.colors = colors;
        this.formats = formats;
    }

    void updateText() {
        this.text = ChatFormat.stripFormat(this.textView.getText());
        this.updateReplacement();
    }

    void updateAnimation() {
        this.updateReplacement();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateReplacement() {
        StringBuilder sb = new StringBuilder(this.text.length() * (9 + this.formats.length()) / 2);
        sb.append(this.randomColor().getFormatCode());
        sb.append(this.formats);
        for (int i = 0; i < this.text.length(); i += Character.charCount(this.text.codePointAt(i))) {
            if (Math.random() < 0.25) {
                sb.append(this.randomColor().getFormatCode());
                sb.append(this.formats);
            }
            sb.appendCodePoint(this.text.codePointAt(i));
        }
        this.replacement = sb.toString();
    }

    private TextColor randomColor() {
        double x = Math.random();
        return this.colors.get((int)(x *= (double)this.colors.size()));
    }

    @Override
    public String getData() {
        return this.replacement;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this);
        this.updateText();
        this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::updateAnimation, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void onDeactivation() {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.textView.deactivate();
    }

    @Override
    public void onTextUpdated() {
        this.updateText();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

