/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CustomPlaceholderColorAnimationRainbow
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private Future<?> task;
    private TextView textView;
    private final List<TextColor> colors;
    private final String formats;
    private final OptionalInt distance;
    private final float speed;
    private String text;
    private float effectiveDistance;
    private float pos = 0.0f;
    private float period;
    private String replacement;

    public CustomPlaceholderColorAnimationRainbow(TextTemplate textTemplate, List<TextColor> colors, String formats, OptionalInt distance, float speed) {
        this.textView = textTemplate.instantiate();
        this.colors = colors;
        this.formats = formats;
        this.distance = distance;
        this.speed = speed;
    }

    void updateText() {
        this.text = ChatFormat.stripFormat(this.textView.getText());
        this.effectiveDistance = this.distance.isPresent() ? (float)this.distance.getAsInt() : ChatFormat.formattedTextLength(this.text) / (float)(this.colors.size() - 1);
        this.period = this.effectiveDistance * (float)this.colors.size();
        this.updateReplacement();
    }

    void updateAnimation() {
        this.updateReplacement();
        this.pos += this.speed;
        if ((double)this.pos < 0.0) {
            this.pos += this.period;
        }
        if (this.pos > this.period) {
            this.pos -= this.period;
        }
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateReplacement() {
        StringBuilder sb = new StringBuilder(this.text.length() * (9 + this.formats.length()));
        double d = this.pos;
        for (int i = 0; i < this.text.length(); i += Character.charCount(this.text.codePointAt(i))) {
            double sd = d / (double)this.effectiveDistance;
            int ia = (int)sd;
            TextColor a = this.colors.get(ia % this.colors.size());
            TextColor b = this.colors.get((ia + 1) % this.colors.size());
            TextColor c = TextColor.interpolateSine(a, b, sd - (double)ia);
            sb.append(c.getFormatCode());
            sb.append(this.formats);
            sb.appendCodePoint(this.text.codePointAt(i));
            d += ChatFormat.getCharWidth(this.text.codePointAt(i));
        }
        this.replacement = sb.toString();
    }

    @Override
    public String getData() {
        return this.replacement;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this);
        this.updateText();
        if (this.speed != 0.0f) {
            this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::updateAnimation, 100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onDeactivation() {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.textView.deactivate();
    }

    @Override
    public void onTextUpdated() {
        this.updateText();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

