/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CustomPlaceholderColorAnimationGlitter
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private Future<?> task;
    private final TextView textView;
    private final TextColor baseColor;
    private final TextColor effectColor;
    private final String formats;
    private String text;
    private String replacement;

    public CustomPlaceholderColorAnimationGlitter(TextTemplate textTemplate, TextColor baseColor, TextColor effectColor, String formats) {
        this.textView = textTemplate.instantiate();
        this.baseColor = baseColor;
        this.effectColor = effectColor;
        this.formats = formats;
    }

    void updateText() {
        this.text = ChatFormat.stripFormat(this.textView.getText());
        this.updateReplacement();
    }

    void updateAnimation() {
        this.updateReplacement();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    private void updateReplacement() {
        StringBuilder sb = new StringBuilder(this.text.length() * (9 + this.formats.length()) / 2);
        sb.append(this.baseColor.getFormatCode());
        sb.append(this.formats);
        boolean hasBaseColor = true;
        for (int i = 0; i < this.text.length(); i += Character.charCount(this.text.codePointAt(i))) {
            if (!hasBaseColor) {
                sb.append(this.baseColor.getFormatCode());
                sb.append(this.formats);
                hasBaseColor = true;
            } else if (Math.random() < 0.05) {
                sb.append(this.effectColor.getFormatCode());
                sb.append(this.formats);
                hasBaseColor = false;
            }
            sb.appendCodePoint(this.text.codePointAt(i));
        }
        this.replacement = sb.toString();
    }

    @Override
    public String getData() {
        return this.replacement;
    }

    @Override
    protected void onActivation() {
        this.textView.activate(this.getContext(), this);
        this.updateText();
        this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::updateAnimation, 150L, 150L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void onDeactivation() {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.textView.deactivate();
    }

    @Override
    public void onTextUpdated() {
        this.updateText();
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

