/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import de.codecrafter47.taboverlay.config.view.text.TextView;
import de.codecrafter47.taboverlay.config.view.text.TextViewUpdateListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CustomPlaceholderAnimated
extends AbstractActiveElement<Runnable>
implements PlaceholderDataProvider<Context, String>,
TextViewUpdateListener {
    private Future<?> task;
    private final List<TextView> elements;
    private TextView activeElement;
    private int nextElementIndex;
    private final long intervalMS;
    private final boolean randomize;

    public CustomPlaceholderAnimated(List<TextTemplate> elements, float interval, boolean randomize) {
        this.elements = elements.stream().map(TextTemplate::instantiate).collect(Collectors.toList());
        this.intervalMS = (long)(interval * 1000.0f);
        this.randomize = randomize;
        if (randomize) {
            Collections.shuffle(elements);
        }
    }

    @Override
    public String getData() {
        return this.activeElement.getText();
    }

    private void switchActiveElement() {
        this.activeElement.deactivate();
        if (this.nextElementIndex >= this.elements.size()) {
            this.nextElementIndex = 0;
            if (this.randomize) {
                Collections.shuffle(this.elements);
            }
        }
        this.activeElement = this.elements.get(this.nextElementIndex++);
        this.activeElement.activate(this.getContext(), this);
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }

    @Override
    protected void onActivation() {
        this.task = this.getContext().getTabEventQueue().scheduleAtFixedRate(this::switchActiveElement, this.intervalMS, this.intervalMS, TimeUnit.MILLISECONDS);
        this.activeElement = this.elements.get(0);
        this.activeElement.activate(this.getContext(), this);
        this.nextElementIndex = 1;
    }

    @Override
    protected void onDeactivation() {
        this.task.cancel(false);
        this.activeElement.deactivate();
    }

    @Override
    public void onTextUpdated() {
        if (this.hasListener()) {
            ((Runnable)this.getListener()).run();
        }
    }
}

