/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.placeholder;

import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class AbstractPlaceholderResolver<C>
implements PlaceholderResolver<C> {
    private Map<String, PlaceholderResolver<C>> placeholders = new HashMap<String, PlaceholderResolver<C>>();
    private Function<PlaceholderBuilder<C, ?>, PlaceholderBuilder<C, ?>> defaultPlaceholder;

    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<C, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() == 0) {
            if (this.defaultPlaceholder != null) {
                return this.defaultPlaceholder.apply(builder);
            }
            throw new UnknownPlaceholderException();
        }
        String token = args.get(0).getText();
        PlaceholderResolver<C> placeholderResolver = this.placeholders.get(token);
        if (placeholderResolver == null) {
            throw new UnknownPlaceholderException();
        }
        if (!args.isEmpty()) {
            args.remove(0);
        }
        return placeholderResolver.resolve(builder, args, tcc);
    }

    protected final <R, T> void addPlaceholder(String name, PlaceholderResolver<C> resolver) {
        this.placeholders.put(name, resolver);
    }

    public void setDefaultPlaceholder(Function<PlaceholderBuilder<C, ?>, PlaceholderBuilder<C, ?>> defaultPlaceholder) {
        this.defaultPlaceholder = defaultPlaceholder;
    }
}

