/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.misc;

import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;

public class TextColor {
    public static final TextColor COLOR_WHITE = new TextColor(255, 255, 255, "&f");
    public static final TextColor COLOR_YELLOW = new TextColor(255, 255, 85, "&e");
    public static final TextColor COLOR_LIGHT_PURPLE = new TextColor(255, 85, 255, "&d");
    public static final TextColor COLOR_RED = new TextColor(255, 85, 85, "&c");
    public static final TextColor COLOR_AQUA = new TextColor(85, 255, 255, "&b");
    public static final TextColor COLOR_GREEN = new TextColor(85, 255, 85, "&a");
    public static final TextColor COLOR_BLUE = new TextColor(85, 85, 255, "&9");
    public static final TextColor COLOR_DARK_GRAY = new TextColor(85, 85, 85, "&8");
    public static final TextColor COLOR_GRAY = new TextColor(170, 170, 170, "&7");
    public static final TextColor COLOR_GOLD = new TextColor(255, 170, 0, "&6");
    public static final TextColor COLOR_DARK_PURPLE = new TextColor(170, 0, 170, "&5");
    public static final TextColor COLOR_DARK_RED = new TextColor(170, 0, 0, "&4");
    public static final TextColor COLOR_DARK_AQUA = new TextColor(0, 170, 170, "&3");
    public static final TextColor COLOR_DARK_GREEN = new TextColor(0, 170, 0, "&2");
    public static final TextColor COLOR_DARK_BLUE = new TextColor(0, 0, 170, "&1");
    public static final TextColor COLOR_BLACK = new TextColor(0, 0, 0, "&0");
    private final int r;
    private final int g;
    private final int b;
    private final String formatCode;

    public static TextColor parse(String color, TemplateCreationContext tcc, Mark mark) {
        char c;
        if (color.length() == 2 && ((c = color.charAt(0)) == '&' || c == '\u00a7' || c == '#')) {
            switch (color.charAt(1)) {
                case '0': {
                    return COLOR_BLACK;
                }
                case '1': {
                    return COLOR_DARK_BLUE;
                }
                case '2': {
                    return COLOR_DARK_GREEN;
                }
                case '3': {
                    return COLOR_DARK_AQUA;
                }
                case '4': {
                    return COLOR_DARK_RED;
                }
                case '5': {
                    return COLOR_DARK_PURPLE;
                }
                case '6': {
                    return COLOR_GOLD;
                }
                case '7': {
                    return COLOR_GRAY;
                }
                case '8': {
                    return COLOR_DARK_GRAY;
                }
                case '9': {
                    return COLOR_BLUE;
                }
                case 'A': 
                case 'a': {
                    return COLOR_GREEN;
                }
                case 'B': 
                case 'b': {
                    return COLOR_AQUA;
                }
                case 'C': 
                case 'c': {
                    return COLOR_RED;
                }
                case 'D': 
                case 'd': {
                    return COLOR_LIGHT_PURPLE;
                }
                case 'E': 
                case 'e': {
                    return COLOR_YELLOW;
                }
                case 'F': 
                case 'R': 
                case 'f': 
                case 'r': {
                    return COLOR_WHITE;
                }
            }
        }
        if (color.matches("#[a-fA-F0-9]{6}")) {
            int rgb = Integer.parseInt(color.substring(1), 16);
            return new TextColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        if (color.matches("&#[a-fA-F0-9]{6}")) {
            int rgb = Integer.parseInt(color.substring(2), 16);
            return new TextColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        tcc.getErrorHandler().addWarning("Specified color " + color + " does not match expected format.\nExpected a formatting code (e.g. &7) or a hex color (e.g. #012345).", mark);
        return COLOR_WHITE;
    }

    public static TextColor interpolateLinear(TextColor a, TextColor b, double x) {
        double rb = x;
        double ra = 1.0 - rb;
        return new TextColor((int)(ra * (double)a.getR() + rb * (double)b.getR()), (int)(ra * (double)a.getG() + rb * (double)b.getG()), (int)(ra * (double)a.getB() + rb * (double)b.getB()));
    }

    public static TextColor interpolateSine(TextColor a, TextColor b, double x) {
        double rb = Math.sin((x - 0.5) * Math.PI) * 0.5 + 0.5;
        double ra = 1.0 - rb;
        return new TextColor((int)(ra * (double)a.getR() + rb * (double)b.getR()), (int)(ra * (double)a.getG() + rb * (double)b.getG()), (int)(ra * (double)a.getB() + rb * (double)b.getB()));
    }

    public TextColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.formatCode = "&#" + Integer.toHexString(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF).substring(2);
    }

    private TextColor(int r, int g, int b, String formatCode) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.formatCode = formatCode;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public String getFormatCode() {
        return this.formatCode;
    }
}

