/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.misc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.codecrafter47.taboverlay.libs.fastutil.chars.CharOpenHashSet;
import de.codecrafter47.taboverlay.libs.fastutil.chars.CharSet;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;

public class ChatFormat {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Map<String, FontInfo> CHAR_WIDTH;
    private static final String EMPTY_JSON_TEXT = "{\"text\":\"\"}";
    private static final CharSet HEX_CHARS;
    private static final FontInfo DEFAULT_FONT;
    private static final Style STYLE_BOLD;
    private static final Style STYLE_ITALIC;
    private static final Style STYLE_UNDERLINE;
    private static final Style STYLE_STRIKE_THROUGH;
    private static final Style STYLE_OBFUSCATED;
    private static final Style COLOR_WHITE;
    private static final Style COLOR_YELLOW;
    private static final Style COLOR_LIGHT_PURPLE;
    private static final Style COLOR_RED;
    private static final Style COLOR_AQUA;
    private static final Style COLOR_GREEN;
    private static final Style COLOR_BLUE;
    private static final Style COLOR_DARK_GRAY;
    private static final Style COLOR_GRAY;
    private static final Style COLOR_GOLD;
    private static final Style COLOR_DARK_PURPLE;
    private static final Style COLOR_DARK_RED;
    private static final Style COLOR_DARK_AQUA;
    private static final Style COLOR_DARK_GREEN;
    private static final Style COLOR_DARK_BLUE;
    private static final Style COLOR_BLACK;

    public static String lastFormatCode(String text) {
        if (text == null) {
            return null;
        }
        String output = null;
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style == null) continue;
            output = text.substring(i, i + style.formatCodeLength);
        }
        return output;
    }

    public static String formattedTextToJson(String text) {
        if (text == null || text.isEmpty()) {
            return EMPTY_JSON_TEXT;
        }
        StringBuilder jsonBuilder = new StringBuilder("{\"text\":\"\",\"extra\":[");
        StringBuilder builder = new StringBuilder();
        boolean bold = false;
        boolean italic = false;
        boolean underlined = false;
        boolean strikeout = false;
        boolean obfuscated = false;
        boolean first = true;
        String color = "white";
        String font = null;
        for (int i = 0; i < text.length(); ++i) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style != null) {
                if (builder.length() > 0) {
                    if (first) {
                        first = false;
                    } else {
                        jsonBuilder.append(",");
                    }
                    jsonBuilder.append("{\"text\":\"").append(builder.toString()).append("\"");
                    jsonBuilder.append(",\"color\":\"").append(color).append("\"");
                    if (font != null) {
                        jsonBuilder.append(",\"font\":\"").append(font).append("\"");
                    }
                    if (bold) {
                        jsonBuilder.append(",\"bold\":\"true\"");
                    }
                    if (italic) {
                        jsonBuilder.append(",\"italic\":\"true\"");
                    }
                    if (underlined) {
                        jsonBuilder.append(",\"underlined\":\"true\"");
                    }
                    if (strikeout) {
                        jsonBuilder.append(",\"strikethrough\":\"true\"");
                    }
                    if (obfuscated) {
                        jsonBuilder.append(",\"obfuscated\":\"true\"");
                    }
                    jsonBuilder.append("}");
                    builder.setLength(0);
                }
                switch (style.type) {
                    case BOLD: {
                        bold = true;
                        break;
                    }
                    case ITALIC: {
                        italic = true;
                        break;
                    }
                    case UNDERLINE: {
                        underlined = true;
                        break;
                    }
                    case STRIKE_THROUGH: {
                        strikeout = true;
                        break;
                    }
                    case OBFUSCATED: {
                        obfuscated = true;
                        break;
                    }
                    case COLOR: {
                        bold = false;
                        italic = false;
                        underlined = false;
                        strikeout = false;
                        obfuscated = false;
                        color = style.stringValue;
                        break;
                    }
                    case FONT: {
                        font = style.stringValue;
                    }
                }
                i += style.formatCodeLength - 1;
                continue;
            }
            char c = text.charAt(i);
            if (ChatFormat.mustEscape(c)) {
                builder.append(ChatFormat.escape(c));
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            jsonBuilder.append("{\"text\":\"").append(builder.toString()).append("\"");
            jsonBuilder.append(",\"color\":\"").append(color).append("\"");
            if (font != null) {
                jsonBuilder.append(",\"font\":\"").append(font).append("\"");
            }
            if (bold) {
                jsonBuilder.append(",\"bold\":\"true\"");
            }
            if (italic) {
                jsonBuilder.append(",\"italic\":\"true\"");
            }
            if (underlined) {
                jsonBuilder.append(",\"underlined\":\"true\"");
            }
            if (strikeout) {
                jsonBuilder.append(",\"strikethrough\":\"true\"");
            }
            if (obfuscated) {
                jsonBuilder.append(",\"obfuscated\":\"true\"");
            }
            jsonBuilder.append("}");
            builder.setLength(0);
        }
        if (first) {
            return EMPTY_JSON_TEXT;
        }
        jsonBuilder.append("]}");
        return jsonBuilder.toString();
    }

    public static String formattedTextToLegacy(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style == null) {
                sb.appendCodePoint(text.codePointAt(i));
                continue;
            }
            if (style.formatCodeLength == 2) {
                sb.append('\u00a7');
                sb.appendCodePoint(text.codePointAt(i + 1));
            }
            i += style.formatCodeLength - 1;
        }
        return sb.toString();
    }

    private static Style readFormatCode(String text, int index) {
        char c = text.charAt(index);
        if (index + 1 < text.length() && ChatFormat.isFormatChar(c)) {
            switch (text.charAt(index + 1)) {
                case '0': {
                    return COLOR_BLACK;
                }
                case '1': {
                    return COLOR_DARK_BLUE;
                }
                case '2': {
                    return COLOR_DARK_GREEN;
                }
                case '3': {
                    return COLOR_DARK_AQUA;
                }
                case '4': {
                    return COLOR_DARK_RED;
                }
                case '5': {
                    return COLOR_DARK_PURPLE;
                }
                case '6': {
                    return COLOR_GOLD;
                }
                case '7': {
                    return COLOR_GRAY;
                }
                case '8': {
                    return COLOR_DARK_GRAY;
                }
                case '9': {
                    return COLOR_BLUE;
                }
                case 'A': 
                case 'a': {
                    return COLOR_GREEN;
                }
                case 'B': 
                case 'b': {
                    return COLOR_AQUA;
                }
                case 'C': 
                case 'c': {
                    return COLOR_RED;
                }
                case 'D': 
                case 'd': {
                    return COLOR_LIGHT_PURPLE;
                }
                case 'E': 
                case 'e': {
                    return COLOR_YELLOW;
                }
                case 'F': 
                case 'R': 
                case 'f': 
                case 'r': {
                    return COLOR_WHITE;
                }
                case 'K': 
                case 'k': {
                    return STYLE_OBFUSCATED;
                }
                case 'L': 
                case 'l': {
                    return STYLE_BOLD;
                }
                case 'M': 
                case 'm': {
                    return STYLE_STRIKE_THROUGH;
                }
                case 'N': 
                case 'n': {
                    return STYLE_UNDERLINE;
                }
                case 'O': 
                case 'o': {
                    return STYLE_ITALIC;
                }
                case 'x': {
                    if (!ChatFormat.isFormatChar(c) || index + 13 >= text.length() || !ChatFormat.isFormatChar(text.charAt(index + 2)) || !ChatFormat.isFormatChar(text.charAt(index + 4)) || !ChatFormat.isFormatChar(text.charAt(index + 6)) || !ChatFormat.isFormatChar(text.charAt(index + 8)) || !ChatFormat.isFormatChar(text.charAt(index + 10)) || !ChatFormat.isFormatChar(text.charAt(index + 12))) break;
                    return new Style(Style.Type.COLOR, ChatFormat.escape("#" + text.charAt(index + 3) + text.charAt(index + 5) + text.charAt(index + 7) + text.charAt(index + 9) + text.charAt(index + 11) + text.charAt(index + 13)), 14);
                }
                case '#': {
                    if (index + 7 >= text.length() || !HEX_CHARS.contains(text.charAt(index + 2)) || !HEX_CHARS.contains(text.charAt(index + 3)) || !HEX_CHARS.contains(text.charAt(index + 4)) || !HEX_CHARS.contains(text.charAt(index + 5)) || !HEX_CHARS.contains(text.charAt(index + 6)) || !HEX_CHARS.contains(text.charAt(index + 7))) break;
                    return new Style(Style.Type.COLOR, text.substring(index + 1, index + 8), 8);
                }
            }
        }
        if (c == '[') {
            int endIdx;
            if (text.regionMatches(true, index, "[color=", 0, 7) && (endIdx = text.indexOf(93, index + 7)) >= 0) {
                return new Style(Style.Type.COLOR, ChatFormat.escape(text.substring(index + 7, endIdx)), endIdx + 1 - index);
            }
            if (text.regionMatches(true, index, "[font=", 0, 6) && (endIdx = text.indexOf(93, index + 6)) >= 0) {
                return new Style(Style.Type.FONT, ChatFormat.escape(text.substring(index + 6, endIdx)), endIdx + 1 - index);
            }
        }
        if (c == '{' && index + 8 < text.length() && text.charAt(index + 1) == '#' && HEX_CHARS.contains(text.charAt(index + 2)) && HEX_CHARS.contains(text.charAt(index + 3)) && HEX_CHARS.contains(text.charAt(index + 4)) && HEX_CHARS.contains(text.charAt(index + 5)) && HEX_CHARS.contains(text.charAt(index + 6)) && HEX_CHARS.contains(text.charAt(index + 7)) && text.charAt(index + 8) == '}') {
            return new Style(Style.Type.COLOR, text.substring(index + 1, index + 8), 9);
        }
        return null;
    }

    private static boolean isFormatChar(char c) {
        return c == '&' || c == '\u00a7';
    }

    private static boolean mustEscape(char c) {
        return c == '\"' || c == '\\' || c <= '\u001f';
    }

    private static String escape(char c) {
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c <= '\u000f') {
            return "\\u000" + Integer.toHexString(c).toUpperCase();
        }
        return "\\u00" + Integer.toHexString(c).toUpperCase();
    }

    private static String escape(String s) {
        boolean mustEscape = false;
        for (int i = 0; i < s.length(); ++i) {
            mustEscape |= ChatFormat.mustEscape(s.charAt(i));
        }
        if (mustEscape) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                if (ChatFormat.mustEscape(s.charAt(i))) {
                    sb.append(ChatFormat.escape(s.charAt(i)));
                    continue;
                }
                sb.append(s.charAt(i));
            }
            return sb.toString();
        }
        return s;
    }

    public static double getCharWidth(int codePoint) {
        return ChatFormat.getCharWidth(codePoint, DEFAULT_FONT, false);
    }

    private static double getCharWidth(int codePoint, FontInfo font, boolean isBold) {
        int index = Arrays.binarySearch(font.codePoints, codePoint);
        if (index < 0) {
            return isBold ? 7.0 : 6.0;
        }
        return isBold ? (double)font.advanceBf[index] : (double)font.advance[index];
    }

    public static float formattedTextLength(String text) {
        float length = 0.0f;
        boolean bold = false;
        FontInfo font = DEFAULT_FONT;
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style != null) {
                if (style.type == Style.Type.COLOR) {
                    bold = false;
                } else if (style.type == Style.Type.BOLD) {
                    bold = true;
                } else if (style.type == Style.Type.FONT && (font = CHAR_WIDTH.get(style.stringValue)) == null) {
                    font = DEFAULT_FONT;
                }
                i += style.formatCodeLength - 1;
                continue;
            }
            length = (float)((double)length + ChatFormat.getCharWidth(text.codePointAt(i), font, bold));
        }
        return length;
    }

    public static String cropFormattedText(String text, float maxLength) {
        float length = 0.0f;
        boolean bold = false;
        FontInfo font = DEFAULT_FONT;
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style != null) {
                if (style.type == Style.Type.COLOR) {
                    bold = false;
                } else if (style.type == Style.Type.BOLD) {
                    bold = true;
                } else if (style.type == Style.Type.FONT && (font = CHAR_WIDTH.get(style.stringValue)) == null) {
                    font = DEFAULT_FONT;
                }
                i += style.formatCodeLength - 1;
                continue;
            }
            if (!((length = (float)((double)length + ChatFormat.getCharWidth(text.codePointAt(i), font, bold))) > maxLength)) continue;
            return text.substring(0, i);
        }
        return text;
    }

    public static String stripFormat(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            Style style = ChatFormat.readFormatCode(text, i);
            if (style == null) {
                sb.appendCodePoint(text.codePointAt(i));
                continue;
            }
            i += style.formatCodeLength - 1;
        }
        return sb.toString();
    }

    public static String createSpaces(float length) {
        int i;
        int spaces = (int)Math.floor(length / 4.0f);
        int boldCharacters = (int)Math.floor(length - (float)spaces * 4.0f);
        StringBuilder sb = new StringBuilder(spaces + 30);
        sb.append("[font=minecraft:default]&r");
        for (i = 0; i < spaces - boldCharacters; ++i) {
            sb.append(' ');
        }
        sb.append("&l");
        while (i < spaces) {
            sb.append(' ');
            ++i;
        }
        sb.append("&r");
        return sb.toString();
    }

    public static String createSpacesExact(float length) {
        float missing;
        String spaces = ChatFormat.createSpaces(length);
        StringBuilder sb = new StringBuilder(spaces);
        for (missing = length - ChatFormat.formattedTextLength(spaces); missing >= 2.0f; missing -= 2.0f) {
            sb.append('\u061e');
        }
        if (missing >= 1.0f) {
            sb.append('\u205a');
        }
        if (sb.length() >= 1 && missing > 0.0f) {
            sb.insert(sb.length() - 1, "&l");
            sb.append("&r");
        }
        return sb.toString();
    }

    static {
        HEX_CHARS = new CharOpenHashSet(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F'});
        InputStream resourceAsStream = ChatFormat.class.getResourceAsStream("char-width.json");
        InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
        CHAR_WIDTH = (Map)new Gson().fromJson((Reader)inputStreamReader, new TypeToken<Map<String, FontInfo>>(){}.getType());
        DEFAULT_FONT = CHAR_WIDTH.get("minecraft:default");
        STYLE_BOLD = new Style(Style.Type.BOLD, null, 2);
        STYLE_ITALIC = new Style(Style.Type.ITALIC, null, 2);
        STYLE_UNDERLINE = new Style(Style.Type.UNDERLINE, null, 2);
        STYLE_STRIKE_THROUGH = new Style(Style.Type.STRIKE_THROUGH, null, 2);
        STYLE_OBFUSCATED = new Style(Style.Type.OBFUSCATED, null, 2);
        COLOR_WHITE = new Style(Style.Type.COLOR, "white", 2);
        COLOR_YELLOW = new Style(Style.Type.COLOR, "yellow", 2);
        COLOR_LIGHT_PURPLE = new Style(Style.Type.COLOR, "light_purple", 2);
        COLOR_RED = new Style(Style.Type.COLOR, "red", 2);
        COLOR_AQUA = new Style(Style.Type.COLOR, "aqua", 2);
        COLOR_GREEN = new Style(Style.Type.COLOR, "green", 2);
        COLOR_BLUE = new Style(Style.Type.COLOR, "blue", 2);
        COLOR_DARK_GRAY = new Style(Style.Type.COLOR, "dark_gray", 2);
        COLOR_GRAY = new Style(Style.Type.COLOR, "gray", 2);
        COLOR_GOLD = new Style(Style.Type.COLOR, "gold", 2);
        COLOR_DARK_PURPLE = new Style(Style.Type.COLOR, "dark_purple", 2);
        COLOR_DARK_RED = new Style(Style.Type.COLOR, "dark_red", 2);
        COLOR_DARK_AQUA = new Style(Style.Type.COLOR, "dark_aqua", 2);
        COLOR_DARK_GREEN = new Style(Style.Type.COLOR, "dark_green", 2);
        COLOR_DARK_BLUE = new Style(Style.Type.COLOR, "dark_blue", 2);
        COLOR_BLACK = new Style(Style.Type.COLOR, "black", 2);
    }

    private static class Style {
        Type type;
        String stringValue;
        int formatCodeLength;

        public Style(Type type, String stringValue, int formatCodeLength) {
            this.type = type;
            this.stringValue = stringValue;
            this.formatCodeLength = formatCodeLength;
        }

        private static enum Type {
            BOLD,
            ITALIC,
            UNDERLINE,
            STRIKE_THROUGH,
            OBFUSCATED,
            COLOR,
            FONT;

        }
    }

    private static class FontInfo {
        private int[] codePoints;
        private float[] advance;
        private float[] advanceBf;

        private FontInfo() {
        }
    }
}

