/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression.token;

import com.google.common.collect.Ordering;
import de.codecrafter47.taboverlay.config.expression.token.Token;
import de.codecrafter47.taboverlay.config.expression.token.TokenReader;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ExpressionTokenizer {
    private static final Ordering<TokenReader> TOKEN_READER_ORDERING = Ordering.from(Comparator.comparingInt(TokenReader::getPriority)).reverse();
    private final List<TokenReader> tokenReaders;

    public ExpressionTokenizer(Iterable<TokenReader> tokenReaders) {
        this.tokenReaders = TOKEN_READER_ORDERING.immutableSortedCopy(tokenReaders);
    }

    public List<Token> parse(TemplateCreationContext tcc, String text, Mark mark) {
        LinkedList<Token> tokens;
        block3: {
            ParsePosition position = new ParsePosition(0);
            tokens = new LinkedList<Token>();
            block0: while (true) {
                if (position.getIndex() < text.length() && Character.isWhitespace(text.charAt(position.getIndex()))) {
                    position.setIndex(position.getIndex() + 1);
                    continue;
                }
                if (position.getIndex() >= text.length()) break block3;
                for (TokenReader tokenReader : this.tokenReaders) {
                    Token token = tokenReader.read(text, position, mark, tcc);
                    if (null == token) continue;
                    tokens.add(token);
                    continue block0;
                }
                break;
            }
            tcc.getErrorHandler().addError(String.format("Illegal token '%c' at index %d in \"%s\"", Character.valueOf(text.charAt(position.getIndex())), position.getIndex(), text), mark);
        }
        return tokens;
    }
}

