/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression.template;

import de.codecrafter47.taboverlay.config.expression.Expressions;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.expression.template.AbstractBooleanExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.AbstractDoubleExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.AbstractStringExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionTemplates {
    public static ExpressionTemplate negate(ExpressionTemplate template) {
        return new Negation(template);
    }

    public static ExpressionTemplate and(Collection<ExpressionTemplate> operands) {
        return new And(operands);
    }

    public static ExpressionTemplate or(Collection<ExpressionTemplate> operands) {
        return new Or(operands);
    }

    public static ExpressionTemplate concat(Collection<ExpressionTemplate> operands) {
        return new Concatenate(operands);
    }

    public static ExpressionTemplate equal(ExpressionTemplate a, ExpressionTemplate b) {
        return new Equal(a, b);
    }

    public static ExpressionTemplate notEqual(ExpressionTemplate a, ExpressionTemplate b) {
        return new NotEqual(a, b);
    }

    public static ExpressionTemplate greater(ExpressionTemplate a, ExpressionTemplate b) {
        return new Greater(a, b);
    }

    public static ExpressionTemplate greaterOrEqual(ExpressionTemplate a, ExpressionTemplate b) {
        return new GreaterOrEqual(a, b);
    }

    public static ExpressionTemplate less(ExpressionTemplate a, ExpressionTemplate b) {
        return new Less(a, b);
    }

    public static ExpressionTemplate lessOrEqual(ExpressionTemplate a, ExpressionTemplate b) {
        return new LessOrEqual(a, b);
    }

    public static ExpressionTemplate sum(Collection<ExpressionTemplate> operands) {
        return new Sum(operands);
    }

    public static ExpressionTemplate product(Collection<ExpressionTemplate> operands) {
        return new Product(operands);
    }

    public static ExpressionTemplate sub(ExpressionTemplate a, ExpressionTemplate b) {
        return new Sub(a, b);
    }

    public static ExpressionTemplate div(ExpressionTemplate a, ExpressionTemplate b) {
        return new Div(a, b);
    }

    public static ExpressionTemplate negateNumber(ExpressionTemplate template) {
        return new NegationNumber(template);
    }

    public static ExpressionTemplate applyStringToStringFunction(ExpressionTemplate template, Function<String, String> function) {
        return new ApplyStringToStringFunction(template, function);
    }

    private ExpressionTemplates() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Negation
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate template;

        Negation(ExpressionTemplate template) {
            this.template = template;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.negate(this.template.instantiateWithBooleanResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.template.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Negation)) {
                return false;
            }
            Negation other = (Negation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$template = this.template;
            ExpressionTemplate other$template = other.template;
            return !(this$template == null ? other$template != null : !this$template.equals(other$template));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Negation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $template = this.template;
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            return result;
        }
    }

    private static class And
    extends AbstractBooleanExpressionTemplate {
        private final Collection<ExpressionTemplate> operands;

        And(Collection<ExpressionTemplate> operands) {
            this.operands = operands;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.and(this.operands.stream().map(ExpressionTemplate::instantiateWithBooleanResult).collect(Collectors.toList()));
        }

        @Override
        public boolean requiresViewerContext() {
            return this.operands.stream().anyMatch(ExpressionTemplate::requiresViewerContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ExpressionTemplate> this$operands = this.operands;
            Collection<ExpressionTemplate> other$operands = other.operands;
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof And;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ExpressionTemplate> $operands = this.operands;
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }
    }

    private static class Or
    extends AbstractBooleanExpressionTemplate {
        private final Collection<ExpressionTemplate> operands;

        Or(Collection<ExpressionTemplate> operands) {
            this.operands = operands;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.or(this.operands.stream().map(ExpressionTemplate::instantiateWithBooleanResult).collect(Collectors.toList()));
        }

        @Override
        public boolean requiresViewerContext() {
            return this.operands.stream().anyMatch(ExpressionTemplate::requiresViewerContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ExpressionTemplate> this$operands = this.operands;
            Collection<ExpressionTemplate> other$operands = other.operands;
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Or;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ExpressionTemplate> $operands = this.operands;
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }
    }

    private static class Concatenate
    extends AbstractStringExpressionTemplate {
        private final Collection<ExpressionTemplate> operands;

        Concatenate(Collection<ExpressionTemplate> operands) {
            this.operands = operands;
        }

        @Override
        public ToStringExpression instantiateWithStringResult() {
            return Expressions.concat(this.operands.stream().map(ExpressionTemplate::instantiateWithStringResult).collect(Collectors.toList()));
        }

        @Override
        public boolean requiresViewerContext() {
            return this.operands.stream().anyMatch(ExpressionTemplate::requiresViewerContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Concatenate)) {
                return false;
            }
            Concatenate other = (Concatenate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ExpressionTemplate> this$operands = this.operands;
            Collection<ExpressionTemplate> other$operands = other.operands;
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Concatenate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ExpressionTemplate> $operands = this.operands;
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }
    }

    private static class Equal
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        Equal(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.equal(this.a.instantiateWithStringResult(), this.b.instantiateWithStringResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Equal)) {
                return false;
            }
            Equal other = (Equal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Equal;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class NotEqual
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        NotEqual(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.notEqual(this.a.instantiateWithStringResult(), this.b.instantiateWithStringResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotEqual)) {
                return false;
            }
            NotEqual other = (NotEqual)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotEqual;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class Greater
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        Greater(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.greaterThan(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Greater)) {
                return false;
            }
            Greater other = (Greater)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Greater;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class GreaterOrEqual
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        GreaterOrEqual(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.greaterOrEqualThan(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GreaterOrEqual)) {
                return false;
            }
            GreaterOrEqual other = (GreaterOrEqual)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GreaterOrEqual;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class Less
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        Less(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.lesserThan(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Less)) {
                return false;
            }
            Less other = (Less)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Less;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class LessOrEqual
    extends AbstractBooleanExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        LessOrEqual(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToBooleanExpression instantiateWithBooleanResult() {
            return Expressions.lesserOrEqualThan(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LessOrEqual)) {
                return false;
            }
            LessOrEqual other = (LessOrEqual)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LessOrEqual;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class Sum
    extends AbstractDoubleExpressionTemplate {
        private final Collection<ExpressionTemplate> operands;

        Sum(Collection<ExpressionTemplate> operands) {
            this.operands = operands;
        }

        @Override
        public ToDoubleExpression instantiateWithDoubleResult() {
            return Expressions.sum(this.operands.stream().map(ExpressionTemplate::instantiateWithDoubleResult).collect(Collectors.toList()));
        }

        @Override
        public boolean requiresViewerContext() {
            return this.operands.stream().anyMatch(ExpressionTemplate::requiresViewerContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sum)) {
                return false;
            }
            Sum other = (Sum)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ExpressionTemplate> this$operands = this.operands;
            Collection<ExpressionTemplate> other$operands = other.operands;
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sum;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ExpressionTemplate> $operands = this.operands;
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }
    }

    private static class Product
    extends AbstractDoubleExpressionTemplate {
        private final Collection<ExpressionTemplate> operands;

        Product(Collection<ExpressionTemplate> operands) {
            this.operands = operands;
        }

        @Override
        public ToDoubleExpression instantiateWithDoubleResult() {
            return Expressions.product(this.operands.stream().map(ExpressionTemplate::instantiateWithDoubleResult).collect(Collectors.toList()));
        }

        @Override
        public boolean requiresViewerContext() {
            return this.operands.stream().anyMatch(ExpressionTemplate::requiresViewerContext);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Product)) {
                return false;
            }
            Product other = (Product)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<ExpressionTemplate> this$operands = this.operands;
            Collection<ExpressionTemplate> other$operands = other.operands;
            return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Product;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<ExpressionTemplate> $operands = this.operands;
            result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
            return result;
        }
    }

    private static class Sub
    extends AbstractDoubleExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        Sub(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToDoubleExpression instantiateWithDoubleResult() {
            return Expressions.sub(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sub)) {
                return false;
            }
            Sub other = (Sub)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sub;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class Div
    extends AbstractDoubleExpressionTemplate {
        private final ExpressionTemplate a;
        private final ExpressionTemplate b;

        Div(ExpressionTemplate a, ExpressionTemplate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public ToDoubleExpression instantiateWithDoubleResult() {
            return Expressions.div(this.a.instantiateWithDoubleResult(), this.b.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.a.requiresViewerContext() || this.b.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Div)) {
                return false;
            }
            Div other = (Div)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$a = this.a;
            ExpressionTemplate other$a = other.a;
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            ExpressionTemplate this$b = this.b;
            ExpressionTemplate other$b = other.b;
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Div;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $a = this.a;
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            ExpressionTemplate $b = this.b;
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }
    }

    private static class NegationNumber
    extends AbstractDoubleExpressionTemplate {
        private final ExpressionTemplate template;

        NegationNumber(ExpressionTemplate template) {
            this.template = template;
        }

        @Override
        public ToDoubleExpression instantiateWithDoubleResult() {
            return Expressions.negateNumber(this.template.instantiateWithDoubleResult());
        }

        @Override
        public boolean requiresViewerContext() {
            return this.template.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NegationNumber)) {
                return false;
            }
            NegationNumber other = (NegationNumber)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$template = this.template;
            ExpressionTemplate other$template = other.template;
            return !(this$template == null ? other$template != null : !this$template.equals(other$template));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NegationNumber;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $template = this.template;
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            return result;
        }
    }

    private static class ApplyStringToStringFunction
    extends AbstractStringExpressionTemplate {
        private final ExpressionTemplate template;
        private final Function<String, String> function;

        ApplyStringToStringFunction(ExpressionTemplate template, Function<String, String> function) {
            this.template = template;
            this.function = function;
        }

        @Override
        public ToStringExpression instantiateWithStringResult() {
            return Expressions.applyToStringFunction(this.template.instantiateWithStringResult(), this.function);
        }

        @Override
        public boolean requiresViewerContext() {
            return this.template.requiresViewerContext();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplyStringToStringFunction)) {
                return false;
            }
            ApplyStringToStringFunction other = (ApplyStringToStringFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionTemplate this$template = this.template;
            ExpressionTemplate other$template = other.template;
            if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
                return false;
            }
            Function<String, String> this$function = this.function;
            Function<String, String> other$function = other.function;
            return !(this$function == null ? other$function != null : !this$function.equals(other$function));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplyStringToStringFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionTemplate $template = this.template;
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            Function<String, String> $function = this.function;
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            return result;
        }
    }
}

