/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression.template;

import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;

public class ConstantExpressionTemplate
implements ExpressionTemplate {
    private final ToStringExpression stringExpression;
    private final ToDoubleExpression doubleExpression;
    private final ToBooleanExpression booleanExpression;

    private ConstantExpressionTemplate(String stringValue, double doubleValue, boolean booleanValue) {
        this.stringExpression = ToStringExpression.literal(stringValue);
        this.doubleExpression = ToDoubleExpression.literal(doubleValue);
        this.booleanExpression = ToBooleanExpression.literal(booleanValue);
    }

    public static ConstantExpressionTemplate of(String stringValue) {
        double doubleValue;
        try {
            doubleValue = Double.parseDouble(stringValue);
        }
        catch (NumberFormatException ex) {
            doubleValue = stringValue.length();
        }
        return new ConstantExpressionTemplate(stringValue, doubleValue, Boolean.parseBoolean(stringValue));
    }

    public static ConstantExpressionTemplate of(double doubleValue) {
        return new ConstantExpressionTemplate((double)((int)doubleValue) == doubleValue ? Integer.toString((int)doubleValue) : Double.toString(doubleValue), doubleValue, doubleValue != 0.0);
    }

    public static ConstantExpressionTemplate of(boolean booleanValue) {
        return new ConstantExpressionTemplate(Boolean.toString(booleanValue), booleanValue ? 1.0 : 0.0, booleanValue);
    }

    @Override
    public ToStringExpression instantiateWithStringResult() {
        return this.stringExpression;
    }

    @Override
    public ToDoubleExpression instantiateWithDoubleResult() {
        return this.doubleExpression;
    }

    @Override
    public ToBooleanExpression instantiateWithBooleanResult() {
        return this.booleanExpression;
    }

    @Override
    public boolean requiresViewerContext() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstantExpressionTemplate)) {
            return false;
        }
        ConstantExpressionTemplate other = (ConstantExpressionTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ToStringExpression this$stringExpression = this.stringExpression;
        ToStringExpression other$stringExpression = other.stringExpression;
        if (this$stringExpression == null ? other$stringExpression != null : !this$stringExpression.equals(other$stringExpression)) {
            return false;
        }
        ToDoubleExpression this$doubleExpression = this.doubleExpression;
        ToDoubleExpression other$doubleExpression = other.doubleExpression;
        if (this$doubleExpression == null ? other$doubleExpression != null : !this$doubleExpression.equals(other$doubleExpression)) {
            return false;
        }
        ToBooleanExpression this$booleanExpression = this.booleanExpression;
        ToBooleanExpression other$booleanExpression = other.booleanExpression;
        return !(this$booleanExpression == null ? other$booleanExpression != null : !this$booleanExpression.equals(other$booleanExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstantExpressionTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ToStringExpression $stringExpression = this.stringExpression;
        result = result * 59 + ($stringExpression == null ? 43 : $stringExpression.hashCode());
        ToDoubleExpression $doubleExpression = this.doubleExpression;
        result = result * 59 + ($doubleExpression == null ? 43 : $doubleExpression.hashCode());
        ToBooleanExpression $booleanExpression = this.booleanExpression;
        result = result * 59 + ($booleanExpression == null ? 43 : $booleanExpression.hashCode());
        return result;
    }
}

