/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.codecrafter47.taboverlay.config.expression.operators.ListOperator;
import de.codecrafter47.taboverlay.config.expression.operators.Operator;
import de.codecrafter47.taboverlay.config.expression.parser.ValueReader;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import de.codecrafter47.taboverlay.config.expression.token.Token;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.ArrayList;
import java.util.List;

public class ExpressionTemplateParser {
    private final ImmutableMap<Token, Operator> operators;
    private final ImmutableList<ValueReader> valueReaders;

    public ExpressionTemplate parse(TemplateCreationContext tcc, List<Token> tokens, Mark mark) {
        ArrayList<ExpressionTemplate> parts = new ArrayList<ExpressionTemplate>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        try {
            parts.add(this.read(tcc, tokens, mark));
        }
        catch (IllegalArgumentException e) {
            tcc.getErrorHandler().addError(e.getMessage(), mark);
            return ConstantExpressionTemplate.of("");
        }
        while (!tokens.isEmpty()) {
            Token token = tokens.remove(0);
            Operator operator = (Operator)this.operators.get((Object)token);
            if (operator == null) {
                tcc.getErrorHandler().addError("Error parsing expression: Got " + token + " expected OPERATOR", mark);
                return ConstantExpressionTemplate.of("");
            }
            operators.add(operator);
            if (tokens.isEmpty()) {
                tcc.getErrorHandler().addError("Unexpected end of input", mark);
                return ConstantExpressionTemplate.of("");
            }
            try {
                parts.add(this.read(tcc, tokens, mark));
            }
            catch (IllegalArgumentException e) {
                tcc.getErrorHandler().addError(e.getMessage(), mark);
                return ConstantExpressionTemplate.of("");
            }
        }
        while (!operators.isEmpty()) {
            ExpressionTemplate replacement;
            Operator operator = (Operator)operators.get(0);
            int lowest = operator.getPriority();
            int start = 0;
            int end = 1;
            for (int i = 1; i < operators.size(); ++i) {
                operator = (Operator)operators.get(i);
                if (operator.getPriority() < lowest) {
                    lowest = operator.getPriority();
                    start = i;
                    end = i + 1;
                    continue;
                }
                if (operator.getPriority() > lowest) break;
                ++end;
            }
            operator = (Operator)operators.get(start);
            if (start + 1 == end) {
                replacement = operator.createTemplate((ExpressionTemplate)parts.get(start), (ExpressionTemplate)parts.get(end));
            } else if (operator instanceof ListOperator) {
                replacement = ((ListOperator)operator).createTemplate(new ArrayList<ExpressionTemplate>(parts.subList(start, end + 1)));
            } else {
                ArrayList<ExpressionTemplate> conditions = new ArrayList<ExpressionTemplate>(end - start);
                for (int i = start; i < end; ++i) {
                    conditions.add(((Operator)operators.get(i)).createTemplate((ExpressionTemplate)parts.get(i), (ExpressionTemplate)parts.get(i + 1)));
                }
                replacement = ExpressionTemplates.and(conditions);
            }
            for (int i = start; i < end; ++i) {
                parts.remove(start);
                operators.remove(start);
            }
            parts.set(start, replacement);
        }
        return (ExpressionTemplate)parts.get(0);
    }

    ExpressionTemplate read(TemplateCreationContext tcc, List<Token> tokens, Mark mark) {
        for (ValueReader valueReader : this.valueReaders) {
            ExpressionTemplate template = valueReader.read(tcc, this, tokens, mark);
            if (template == null) continue;
            return template;
        }
        throw new IllegalArgumentException("Invalid Expression Syntax. Got Token " + tokens.get(0).toString() + " expected literal or placeholder.");
    }

    public ExpressionTemplateParser(ImmutableMap<Token, Operator> operators, ImmutableList<ValueReader> valueReaders) {
        this.operators = operators;
        this.valueReaders = valueReaders;
    }
}

