/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression;

import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.Expression;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ToDoubleExpression
extends Expression {
    public double evaluate();

    public static ToDoubleExpression literal(double value) {
        return new ConstantToDoubleExpression(value);
    }

    public static class ConstantToDoubleExpression
    implements ToDoubleExpression {
        private final double value;

        private ConstantToDoubleExpression(double value) {
            this.value = value;
        }

        @Override
        public double evaluate() {
            return this.value;
        }

        @Override
        public void activate(@Nonnull Context context, @Nullable ExpressionUpdateListener listener) {
        }

        @Override
        public void deactivate() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstantToDoubleExpression)) {
                return false;
            }
            ConstantToDoubleExpression other = (ConstantToDoubleExpression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Double.compare(this.value, other.value) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstantToDoubleExpression;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $value = Double.doubleToLongBits(this.value);
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }
    }
}

