/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression;

import de.codecrafter47.taboverlay.config.expression.AbstractBinaryToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractBinaryToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractToStringExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToStringExpression;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;

public final class Expressions {
    public static ToBooleanExpression negate(ToBooleanExpression expression) {
        return new AbstractUnaryToBooleanExpression<ToBooleanExpression>(expression){

            @Override
            public boolean evaluate() {
                return !((ToBooleanExpression)this.delegate).evaluate();
            }
        };
    }

    public static ToBooleanExpression and(Collection<ToBooleanExpression> operands) {
        return new AbstractToBooleanExpression<ToBooleanExpression>(operands){

            @Override
            public boolean evaluate() {
                for (ToBooleanExpression operand : this.operands) {
                    if (operand.evaluate()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ToBooleanExpression or(Collection<ToBooleanExpression> operands) {
        return new AbstractToBooleanExpression<ToBooleanExpression>(operands){

            @Override
            public boolean evaluate() {
                for (ToBooleanExpression operand : this.operands) {
                    if (!operand.evaluate()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ToStringExpression concat(Collection<ToStringExpression> operands) {
        return new AbstractToStringExpression<ToStringExpression>(operands){

            @Override
            public String evaluate() {
                StringBuilder result = new StringBuilder();
                for (ToStringExpression operand : this.operands) {
                    result.append(operand.evaluate());
                }
                return result.toString();
            }
        };
    }

    public static ToBooleanExpression equal(ToStringExpression a, ToStringExpression b) {
        return new AbstractBinaryToBooleanExpression<ToStringExpression>(a, b){

            @Override
            public boolean evaluate() {
                return Objects.equals(((ToStringExpression)this.a).evaluate(), ((ToStringExpression)this.b).evaluate());
            }
        };
    }

    public static ToBooleanExpression notEqual(ToStringExpression a, ToStringExpression b) {
        return new AbstractBinaryToBooleanExpression<ToStringExpression>(a, b){

            @Override
            public boolean evaluate() {
                return !Objects.equals(((ToStringExpression)this.a).evaluate(), ((ToStringExpression)this.b).evaluate());
            }
        };
    }

    public static ToBooleanExpression greaterThan(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToBooleanExpression<ToDoubleExpression>(a, b){

            @Override
            public boolean evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() > ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToBooleanExpression greaterOrEqualThan(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToBooleanExpression<ToDoubleExpression>(a, b){

            @Override
            public boolean evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() >= ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToBooleanExpression lesserThan(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToBooleanExpression<ToDoubleExpression>(a, b){

            @Override
            public boolean evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() < ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToBooleanExpression lesserOrEqualThan(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToBooleanExpression<ToDoubleExpression>(a, b){

            @Override
            public boolean evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() <= ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToDoubleExpression sum(Collection<ToDoubleExpression> operands) {
        return new AbstractToDoubleExpression<ToDoubleExpression>(operands){

            @Override
            public double evaluate() {
                double result = 0.0;
                for (ToDoubleExpression operand : this.operands) {
                    result += operand.evaluate();
                }
                return result;
            }
        };
    }

    public static ToDoubleExpression product(Collection<ToDoubleExpression> operands) {
        return new AbstractToDoubleExpression<ToDoubleExpression>(operands){

            @Override
            public double evaluate() {
                double result = 1.0;
                for (ToDoubleExpression operand : this.operands) {
                    result *= operand.evaluate();
                }
                return result;
            }
        };
    }

    public static ToDoubleExpression sub(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToDoubleExpression<ToDoubleExpression>(a, b){

            @Override
            public double evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() - ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToDoubleExpression div(ToDoubleExpression a, ToDoubleExpression b) {
        return new AbstractBinaryToDoubleExpression<ToDoubleExpression>(a, b){

            @Override
            public double evaluate() {
                return ((ToDoubleExpression)this.a).evaluate() / ((ToDoubleExpression)this.b).evaluate();
            }
        };
    }

    public static ToDoubleExpression negateNumber(ToDoubleExpression a) {
        return new AbstractUnaryToDoubleExpression<ToDoubleExpression>(a){

            @Override
            public double evaluate() {
                return -((ToDoubleExpression)this.delegate).evaluate();
            }
        };
    }

    public static ToStringExpression applyToStringFunction(ToStringExpression expression, final Function<String, String> function) {
        return new AbstractUnaryToStringExpression<ToStringExpression>(expression){

            @Override
            public String evaluate() {
                return (String)function.apply(((ToStringExpression)this.delegate).evaluate());
            }
        };
    }

    private Expressions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

