/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.codecrafter47.taboverlay.config.expression.ExpressionEngine;
import de.codecrafter47.taboverlay.config.expression.operators.ListOperator;
import de.codecrafter47.taboverlay.config.expression.operators.Operator;
import de.codecrafter47.taboverlay.config.expression.parser.BooleanConstantReader;
import de.codecrafter47.taboverlay.config.expression.parser.ExpressionTemplateParser;
import de.codecrafter47.taboverlay.config.expression.parser.NegatedExpressionReader;
import de.codecrafter47.taboverlay.config.expression.parser.NegatedNumberReader;
import de.codecrafter47.taboverlay.config.expression.parser.NumberConstantReader;
import de.codecrafter47.taboverlay.config.expression.parser.ParenthesisedExpressionReader;
import de.codecrafter47.taboverlay.config.expression.parser.PlaceholderReader;
import de.codecrafter47.taboverlay.config.expression.parser.StringConstantReader;
import de.codecrafter47.taboverlay.config.expression.parser.ValueReader;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplates;
import de.codecrafter47.taboverlay.config.expression.token.BooleanToken;
import de.codecrafter47.taboverlay.config.expression.token.DefaultTokens;
import de.codecrafter47.taboverlay.config.expression.token.ExpressionTokenizer;
import de.codecrafter47.taboverlay.config.expression.token.NonQuotedLiteralTokenReader;
import de.codecrafter47.taboverlay.config.expression.token.NumberTokenReader;
import de.codecrafter47.taboverlay.config.expression.token.PatternTokenReader;
import de.codecrafter47.taboverlay.config.expression.token.PlaceholderTokenReader;
import de.codecrafter47.taboverlay.config.expression.token.QuotedLiteralTokenReader;
import de.codecrafter47.taboverlay.config.expression.token.Token;
import de.codecrafter47.taboverlay.config.expression.token.TokenReader;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultExpressionEngine
implements ExpressionEngine {
    private final ExpressionTokenizer tokenizer;
    private final ExpressionTemplateParser templateParser;

    public DefaultExpressionEngine(Options options) {
        this.tokenizer = new ExpressionTokenizer(options.tokenReaders);
        this.templateParser = new ExpressionTemplateParser((ImmutableMap<Token, Operator>)options.operators, (ImmutableList<ValueReader>)options.valueReaders);
    }

    @Override
    public ExpressionTemplate compile(TemplateCreationContext tcc, String expression, Mark mark) {
        return this.templateParser.parse(tcc, this.tokenizer.parse(tcc, expression, mark), mark);
    }

    public static class Options {
        private List<TokenReader> tokenReaders;
        private ImmutableMap<Token, Operator> operators;
        private ImmutableList<ValueReader> valueReaders;

        Options(List<TokenReader> tokenReaders, ImmutableMap<Token, Operator> operators, ImmutableList<ValueReader> valueReaders) {
            this.tokenReaders = tokenReaders;
            this.operators = operators;
            this.valueReaders = valueReaders;
        }

        public static OptionsBuilder builder() {
            return new OptionsBuilder();
        }

        public static class OptionsBuilder {
            private ArrayList<TokenReader> tokenReaders;
            private ImmutableMap.Builder<Token, Operator> operators;
            private ImmutableList.Builder<ValueReader> valueReaders;

            public OptionsBuilder withDefaultTokenReaders() {
                return this.tokenReader(new PatternTokenReader(BooleanToken.FALSE, "false")).tokenReader(new PatternTokenReader(BooleanToken.TRUE, "true")).tokenReader(new PatternTokenReader(BooleanToken.TRUE, "all")).tokenReader(new PatternTokenReader(DefaultTokens.AND, "and")).tokenReader(new PatternTokenReader(DefaultTokens.AND, "&&")).tokenReader(new PatternTokenReader(DefaultTokens.OR, "or")).tokenReader(new PatternTokenReader(DefaultTokens.OR, "||")).tokenReader(new PatternTokenReader(DefaultTokens.EQUAL, "==")).tokenReader(new PatternTokenReader(DefaultTokens.EQUAL, "=")).tokenReader(new PatternTokenReader(DefaultTokens.NOT_EQUAL, "!=")).tokenReader(new PatternTokenReader(DefaultTokens.GREATER_OR_EQUAL_THAN, ">=")).tokenReader(new PatternTokenReader(DefaultTokens.LESSER_OR_EQUAL_THAN, "<=")).tokenReader(new PatternTokenReader(DefaultTokens.OPENING_PARENTHESIS, "(")).tokenReader(new PatternTokenReader(DefaultTokens.CLOSING_PARENTHESIS, ")")).tokenReader(new PatternTokenReader(DefaultTokens.NEGATION, "!")).tokenReader(new PatternTokenReader(DefaultTokens.GREATER_THAN, ">")).tokenReader(new PatternTokenReader(DefaultTokens.LESSER_THAN, "<")).tokenReader(new PatternTokenReader(DefaultTokens.CONCAT_STRING, ".")).tokenReader(new PatternTokenReader(DefaultTokens.ADD, "+")).tokenReader(new PatternTokenReader(DefaultTokens.SUB, "-")).tokenReader(new PatternTokenReader(DefaultTokens.MULT, "*")).tokenReader(new PatternTokenReader(DefaultTokens.DIV, "/")).tokenReader(new QuotedLiteralTokenReader(-10, '\"')).tokenReader(new QuotedLiteralTokenReader(-10, '\'')).tokenReader(new PlaceholderTokenReader(-20)).tokenReader(new NumberTokenReader(-50)).tokenReader(new NonQuotedLiteralTokenReader(-100));
            }

            public OptionsBuilder withDefaultOperators() {
                return this.operator(DefaultTokens.AND, ListOperator.of(100, ExpressionTemplates::and)).operator(DefaultTokens.OR, ListOperator.of(50, ExpressionTemplates::or)).operator(DefaultTokens.EQUAL, Operator.of(25, ExpressionTemplates::equal)).operator(DefaultTokens.NOT_EQUAL, Operator.of(25, ExpressionTemplates::notEqual)).operator(DefaultTokens.GREATER_THAN, Operator.of(25, ExpressionTemplates::greater)).operator(DefaultTokens.GREATER_OR_EQUAL_THAN, Operator.of(25, ExpressionTemplates::greaterOrEqual)).operator(DefaultTokens.LESSER_THAN, Operator.of(25, ExpressionTemplates::less)).operator(DefaultTokens.LESSER_OR_EQUAL_THAN, Operator.of(25, ExpressionTemplates::lessOrEqual)).operator(DefaultTokens.CONCAT_STRING, ListOperator.of(10, ExpressionTemplates::concat)).operator(DefaultTokens.ADD, ListOperator.of(4, ExpressionTemplates::sum)).operator(DefaultTokens.SUB, Operator.of(3, ExpressionTemplates::sub)).operator(DefaultTokens.MULT, ListOperator.of(2, ExpressionTemplates::product)).operator(DefaultTokens.DIV, Operator.of(1, ExpressionTemplates::div));
            }

            public OptionsBuilder withDefaultValueReaders() {
                return this.valueReader(new BooleanConstantReader()).valueReader(new NumberConstantReader()).valueReader(new StringConstantReader()).valueReader(new NegatedExpressionReader(DefaultTokens.NEGATION)).valueReader(new ParenthesisedExpressionReader(DefaultTokens.OPENING_PARENTHESIS, DefaultTokens.CLOSING_PARENTHESIS)).valueReader(new PlaceholderReader()).valueReader(new NegatedNumberReader(DefaultTokens.SUB));
            }

            OptionsBuilder() {
            }

            public OptionsBuilder tokenReader(TokenReader tokenReader) {
                if (this.tokenReaders == null) {
                    this.tokenReaders = new ArrayList();
                }
                this.tokenReaders.add(tokenReader);
                return this;
            }

            public OptionsBuilder tokenReaders(Collection<? extends TokenReader> tokenReaders) {
                if (tokenReaders == null) {
                    throw new NullPointerException("tokenReaders cannot be null");
                }
                if (this.tokenReaders == null) {
                    this.tokenReaders = new ArrayList();
                }
                this.tokenReaders.addAll(tokenReaders);
                return this;
            }

            public OptionsBuilder clearTokenReaders() {
                if (this.tokenReaders != null) {
                    this.tokenReaders.clear();
                }
                return this;
            }

            public OptionsBuilder operator(Token key, Operator value) {
                if (this.operators == null) {
                    this.operators = ImmutableMap.builder();
                }
                this.operators.put((Object)key, (Object)value);
                return this;
            }

            public OptionsBuilder operators(Map<? extends Token, ? extends Operator> operators) {
                if (operators == null) {
                    throw new NullPointerException("operators cannot be null");
                }
                if (this.operators == null) {
                    this.operators = ImmutableMap.builder();
                }
                this.operators.putAll(operators);
                return this;
            }

            public OptionsBuilder clearOperators() {
                this.operators = null;
                return this;
            }

            public OptionsBuilder valueReader(ValueReader valueReader) {
                if (this.valueReaders == null) {
                    this.valueReaders = ImmutableList.builder();
                }
                this.valueReaders.add((Object)valueReader);
                return this;
            }

            public OptionsBuilder valueReaders(Iterable<? extends ValueReader> valueReaders) {
                if (valueReaders == null) {
                    throw new NullPointerException("valueReaders cannot be null");
                }
                if (this.valueReaders == null) {
                    this.valueReaders = ImmutableList.builder();
                }
                this.valueReaders.addAll(valueReaders);
                return this;
            }

            public OptionsBuilder clearValueReaders() {
                this.valueReaders = null;
                return this;
            }

            public Options build() {
                List<TokenReader> tokenReaders;
                switch (this.tokenReaders == null ? 0 : this.tokenReaders.size()) {
                    case 0: {
                        tokenReaders = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        tokenReaders = Collections.singletonList(this.tokenReaders.get(0));
                        break;
                    }
                    default: {
                        tokenReaders = Collections.unmodifiableList(new ArrayList<TokenReader>(this.tokenReaders));
                    }
                }
                ImmutableMap operators = this.operators == null ? ImmutableMap.of() : this.operators.build();
                ImmutableList valueReaders = this.valueReaders == null ? ImmutableList.of() : this.valueReaders.build();
                return new Options(tokenReaders, (ImmutableMap<Token, Operator>)operators, (ImmutableList<ValueReader>)valueReaders);
            }

            public String toString() {
                return "DefaultExpressionEngine.Options.OptionsBuilder(tokenReaders=" + this.tokenReaders + ", operators=" + this.operators + ", valueReaders=" + this.valueReaders + ")";
            }
        }
    }
}

