/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.expression;

import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.AbstractUnaryToStringExpression;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.expression.ToDoubleExpression;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class Conversions {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.ROOT);

    public static ToBooleanExpression toBoolean(ToDoubleExpression expression) {
        return new AbstractUnaryToBooleanExpression<ToDoubleExpression>(expression){

            @Override
            public boolean evaluate() {
                return ((ToDoubleExpression)this.delegate).evaluate() != 0.0;
            }
        };
    }

    public static ToBooleanExpression toBoolean(ToStringExpression expression) {
        return new AbstractUnaryToBooleanExpression<ToStringExpression>(expression){

            @Override
            public boolean evaluate() {
                return Boolean.parseBoolean(((ToStringExpression)this.delegate).evaluate());
            }
        };
    }

    public static ToDoubleExpression toDouble(ToBooleanExpression expression) {
        return new AbstractUnaryToDoubleExpression<ToBooleanExpression>(expression){

            @Override
            public double evaluate() {
                return ((ToBooleanExpression)this.delegate).evaluate() ? 1.0 : 0.0;
            }
        };
    }

    public static ToDoubleExpression toDouble(ToStringExpression expression) {
        return new AbstractUnaryToDoubleExpression<ToStringExpression>(expression){

            @Override
            public double evaluate() {
                String result = ((ToStringExpression)this.delegate).evaluate();
                try {
                    return NUMBER_FORMAT.parse(result).doubleValue();
                }
                catch (NumberFormatException | ParseException ignored) {
                    return 0.0;
                }
            }
        };
    }

    public static ToStringExpression toString(ToBooleanExpression expression) {
        return new AbstractUnaryToStringExpression<ToBooleanExpression>(expression){

            @Override
            public String evaluate() {
                return Boolean.toString(((ToBooleanExpression)this.delegate).evaluate());
            }
        };
    }

    public static ToStringExpression toString(ToDoubleExpression expression) {
        return new AbstractUnaryToStringExpression<ToDoubleExpression>(expression){

            @Override
            public String evaluate() {
                double result = ((ToDoubleExpression)this.delegate).evaluate();
                return result == (double)((int)result) ? Integer.toString((int)result) : Double.toString(result);
            }
        };
    }

    private Conversions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

