/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.yaml;

import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.AbstractInheritanceHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.YamlUtil;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.MappingNode;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Node;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.ScalarNode;
import java.util.Map;

public class TypeFieldInheritanceHandler
extends AbstractInheritanceHandler {
    private final String field;
    private final Map<String, Class<?>> subtypes;
    private final Class<?> defaultType;

    @Override
    protected Class<?> getType(Node node) {
        Node node1;
        if (node instanceof MappingNode && (node1 = YamlUtil.get((MappingNode)node, this.field)) != null && node1 instanceof ScalarNode) {
            String value = ((ScalarNode)node1).getValue();
            Class<?> type = this.subtypes.get(value);
            if (type != null) {
                YamlUtil.remove((MappingNode)node, this.field);
                return type;
            }
            ErrorHandler.get().addError("Unknown value set for " + this.field + ": " + value, node1.getStartMark());
            ErrorHandler.get().stopAccepting();
        }
        if (this.defaultType == null) {
            ErrorHandler.get().addError("The " + this.field + " option must be specified to construct " + node.getType().getSimpleName(), node.getStartMark());
            ErrorHandler.get().stopAccepting();
        }
        return this.defaultType;
    }

    public TypeFieldInheritanceHandler(String field, Map<String, Class<?>> subtypes, Class<?> defaultType) {
        this.field = field;
        this.subtypes = subtypes;
        this.defaultType = defaultType;
    }
}

