/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.yaml;

import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.AbstractInheritanceHandler;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Node;
import java.util.Map;

public class TagInheritanceHandler
extends AbstractInheritanceHandler {
    private final Map<String, Class<?>> subtypes;
    private final Class<?> defaultType;

    @Override
    protected Class<?> getType(Node node) {
        Class<?> type = this.subtypes.get(node.getTag().getValue());
        if (type != null) {
            return type;
        }
        if (node.getTag().isSecondary()) {
            return this.unknownTag(node);
        }
        return this.defaultType;
    }

    protected Class<?> unknownTag(Node node) {
        ErrorHandler.get().addError("Unknown tag " + node.getTag().getValue(), node.getStartMark());
        ErrorHandler.get().stopAccepting();
        return this.defaultType;
    }

    public TagInheritanceHandler(Map<String, Class<?>> subtypes, Class<?> defaultType) {
        this.subtypes = subtypes;
        this.defaultType = defaultType;
    }
}

