/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.yaml;

import com.google.common.collect.ImmutableMap;
import de.codecrafter47.taboverlay.config.dsl.yaml.InheritanceHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.UpdateableConfig;
import de.codecrafter47.taboverlay.libs.snakeyaml.constructor.Construct;
import de.codecrafter47.taboverlay.libs.snakeyaml.constructor.Constructor;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.YAMLException;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.MappingNode;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Node;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.NodeTuple;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomYamlConstructor
extends Constructor {
    private static final Set<Tag> PRIMITIVE_TAGS = new HashSet<Tag>(){
        {
            this.add(Tag.YAML);
            this.add(Tag.MERGE);
            this.add(Tag.SET);
            this.add(Tag.PAIRS);
            this.add(Tag.OMAP);
            this.add(Tag.BINARY);
            this.add(Tag.INT);
            this.add(Tag.FLOAT);
            this.add(Tag.TIMESTAMP);
            this.add(Tag.BOOL);
            this.add(Tag.NULL);
            this.add(Tag.STR);
            this.add(Tag.SEQ);
            this.add(Tag.MAP);
        }
    };
    private final ImmutableMap<Class<?>, InheritanceHandler> typeInheritanceHandlerMap;
    private final Map<Tag, Class<?>> tagToClassMap = new HashMap();

    public CustomYamlConstructor(ImmutableMap<Class<?>, InheritanceHandler> typeInheritanceHandlerMap) {
        this.typeInheritanceHandlerMap = typeInheritanceHandlerMap;
    }

    @Override
    protected void processDuplicateKeys(MappingNode node) {
        for (NodeTuple tuple : node.getValue()) {
            Node key = tuple.getKeyNode();
            Tag tag = key.getTag();
            if (!Tag.INT.equals(tag) && !Tag.BOOL.equals(tag)) continue;
            key.setTag(Tag.STR);
        }
        super.processDuplicateKeys(node);
    }

    @Override
    protected Object constructObject(Node node) {
        Object object = super.constructObject(node);
        if (object instanceof MarkedPropertyBase) {
            ((MarkedProperty)object).setStartMark(node.getStartMark());
        }
        return object;
    }

    @Override
    protected Construct getConstructor(Node node) {
        InheritanceHandler newInheritanceHandler;
        InheritanceHandler inheritanceHandler = null;
        while (inheritanceHandler != (newInheritanceHandler = this.getInheritanceHandler(node)) && newInheritanceHandler != null) {
            inheritanceHandler = newInheritanceHandler;
            inheritanceHandler.handle(node);
        }
        return super.getConstructor(node);
    }

    @Override
    protected Object newInstance(Node node) {
        Object instance = super.newInstance(node);
        if (node instanceof MappingNode && instance instanceof UpdateableConfig) {
            ((UpdateableConfig)instance).update((MappingNode)node);
        }
        return instance;
    }

    private InheritanceHandler getInheritanceHandler(Node node) {
        InheritanceHandler inheritanceHandler = (InheritanceHandler)this.typeInheritanceHandlerMap.get((Object)this.tagToClassMap.computeIfAbsent(node.getTag(), this::getClassForTag));
        if (null != inheritanceHandler) {
            return inheritanceHandler;
        }
        return (InheritanceHandler)this.typeInheritanceHandlerMap.get(node.getType());
    }

    private Class<?> getClassForTag(Tag tag) {
        if (!PRIMITIVE_TAGS.contains(tag)) {
            try {
                return Class.forName(tag.getClassName());
            }
            catch (YAMLException | ClassNotFoundException | NullPointerException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, true, CustomYamlConstructor.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name);
        }
    }
}

