/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.yaml;

import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderAliasConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedBooleanProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedFloatProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedListProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedMapProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import de.codecrafter47.taboverlay.libs.snakeyaml.DumperOptions;
import de.codecrafter47.taboverlay.libs.snakeyaml.introspector.Property;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Node;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.NodeTuple;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Tag;
import de.codecrafter47.taboverlay.libs.snakeyaml.representer.Representer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CustomRepresenter
extends Representer {
    public CustomRepresenter() {
        this.representers.put(MarkedFloatProperty.class, data -> this.representData(Float.valueOf(((MarkedFloatProperty)data).getValue())));
        this.representers.put(MarkedBooleanProperty.class, data -> this.representData(((MarkedBooleanProperty)data).isValue()));
        this.representers.put(MarkedIntegerProperty.class, data -> this.representData(((MarkedIntegerProperty)data).getValue()));
        this.representers.put(MarkedStringProperty.class, data -> this.representData(((MarkedStringProperty)data).getValue()));
        this.representers.put(MarkedListProperty.class, data -> this.representData(new ArrayList((Collection)Unchecked.cast(data))));
        this.representers.put(MarkedMapProperty.class, data -> this.representData(new LinkedHashMap((Map)Unchecked.cast(data))));
        this.representers.put(CustomPlaceholderAliasConfiguration.class, data -> this.representData(((CustomPlaceholderAliasConfiguration)data).getReplacement()));
    }

    @Override
    protected Node representScalar(Tag tag, String value) {
        if (value.contains("\n")) {
            return super.representScalar(tag, value, DumperOptions.ScalarStyle.LITERAL);
        }
        return super.representScalar(tag, value, DumperOptions.ScalarStyle.PLAIN);
    }

    @Override
    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        if (javaBean instanceof CustomPlaceholderConfiguration && "parameters".equals(property.getName()) && ((MarkedIntegerProperty)propertyValue).getValue() == 0) {
            return null;
        }
        NodeTuple tuple = super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        if ("true".equals(property.getName()) || "false".equals(property.getName())) {
            tuple.getKeyNode().setTag(Tag.BOOL);
        }
        return tuple;
    }
}

