/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderSelect;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomPlaceholderSelectConfiguration
extends CustomPlaceholderConfiguration {
    private Map<MarkedStringProperty, MarkedStringProperty> replacements;
    private MarkedStringProperty defaultReplacement;

    public MarkedStringProperty getDefault() {
        return this.defaultReplacement;
    }

    public void setDefault(MarkedStringProperty defaultReplacement) {
        this.defaultReplacement = defaultReplacement;
    }

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        LinkedHashMap<ExpressionTemplate, TextTemplate> replacementMap = new LinkedHashMap<ExpressionTemplate, TextTemplate>(this.replacements.size());
        if (ConfigValidationUtil.checkNotNull(tcc, "custom placeholder !select", "replacements", this.replacements, this.getStartMark())) {
            for (Map.Entry<MarkedStringProperty, MarkedStringProperty> entry : this.replacements.entrySet()) {
                if (entry.getKey() == null) {
                    tcc.getErrorHandler().addWarning("Replacement with missing or null key in !select custom placeholder", entry.getValue() != null ? entry.getValue().getStartMark() : this.getStartMark());
                    continue;
                }
                if (entry.getKey().getValue() == null) {
                    tcc.getErrorHandler().addWarning("Replacement with missing or null key in !select custom placeholder", entry.getKey().getStartMark());
                    continue;
                }
                ExpressionTemplate expression = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(entry.getKey().getValue(), args), entry.getKey().getStartMark());
                TextTemplate replacement = TextTemplate.EMPTY;
                if (entry.getValue() != null) {
                    try {
                        replacement = TextTemplate.parse(this.replaceParameters(entry.getValue().getValue(), args), entry.getValue().getStartMark(), tcc);
                    }
                    catch (Exception e) {
                        tcc.getErrorHandler().addError("Failed to parse replacement for custom placeholder: " + e.getMessage(), entry.getValue().getStartMark());
                    }
                }
                replacementMap.put(expression, replacement);
            }
        }
        TextTemplate defaultReplacement = TextTemplate.EMPTY;
        if (this.defaultReplacement != null) {
            defaultReplacement = TextTemplate.parse(this.replaceParameters(this.defaultReplacement.getValue(), args), this.defaultReplacement.getStartMark(), tcc);
        }
        TextTemplate finalDefaultReplacement = defaultReplacement;
        return builder.acquireData(() -> new CustomPlaceholderSelect(replacementMap, finalDefaultReplacement), TypeToken.STRING, finalDefaultReplacement.requiresViewerContext() || replacementMap.keySet().stream().anyMatch(ExpressionTemplate::requiresViewerContext) || replacementMap.values().stream().anyMatch(TextTemplate::requiresViewerContext));
    }

    public Map<MarkedStringProperty, MarkedStringProperty> getReplacements() {
        return this.replacements;
    }

    public MarkedStringProperty getDefaultReplacement() {
        return this.defaultReplacement;
    }

    public void setReplacements(Map<MarkedStringProperty, MarkedStringProperty> replacements) {
        this.replacements = replacements;
    }

    public void setDefaultReplacement(MarkedStringProperty defaultReplacement) {
        this.defaultReplacement = defaultReplacement;
    }
}

