/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import com.google.common.collect.ImmutableMap;
import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedBooleanProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedListProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedMapProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.BarPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderProgressBar;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CustomPlaceholderProgressBarConfiguration
extends CustomPlaceholderConfiguration {
    private MarkedStringProperty value;
    private MarkedStringProperty minValue;
    private MarkedStringProperty maxValue;
    private MarkedStringProperty style;
    private MarkedIntegerProperty length;
    private MarkedStringProperty symbolCompleted;
    private MarkedStringProperty symbolRemaining;
    private MarkedStringProperty symbolCurrent;
    private MarkedListProperty<MarkedStringProperty> symbolCurrentSteps;
    private MarkedStringProperty borderLeft;
    private MarkedStringProperty borderRight;
    private MarkedStringProperty textCenter;
    private MarkedStringProperty textCenterEmpty;
    private MarkedStringProperty textCenterFull;
    private MarkedStringProperty colorCompleted;
    private MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> colorCompletedSteps;
    private MarkedBooleanProperty colorCompletedInterpolateSteps;
    private MarkedStringProperty colorCurrent;
    private MarkedBooleanProperty colorCurrentInterpolate;
    private MarkedStringProperty colorRemaining;
    private MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> colorRemainingSteps;
    private MarkedBooleanProperty colorRemainingInterpolateSteps;
    private MarkedBooleanProperty colorRemainingFromColorCompleted;
    private MarkedStringProperty colorEmptyBar;
    private MarkedStringProperty colorFullBar;
    private MarkedBooleanProperty emptyBarShowSymbols;
    private MarkedBooleanProperty fullBarShowSymbols;
    private MarkedStringProperty emptyBar;
    private MarkedStringProperty fullBar;

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        float symbolCompletedLength;
        float diff;
        Object symbolCurrent;
        TemplateCreationContext barContext = tcc.clone();
        barContext.addPlaceholderResolver(new BarPlaceholderResolver());
        ExpressionTemplate value = ConstantExpressionTemplate.of(0.0);
        if (ConfigValidationUtil.checkNotNull(tcc, "!progress_bar custom placeholder", "value", this.value, this.getStartMark())) {
            value = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(this.value.getValue(), args), this.value.getStartMark());
        }
        ExpressionTemplate minValue = ConstantExpressionTemplate.of(0.0);
        if (this.minValue != null) {
            minValue = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(this.minValue.getValue(), args), this.minValue.getStartMark());
        }
        ExpressionTemplate maxValue = ConstantExpressionTemplate.of(0.0);
        if (ConfigValidationUtil.checkNotNull(tcc, "!progress_bar custom placeholder", "maxValue", this.maxValue, this.getStartMark())) {
            maxValue = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(this.maxValue.getValue(), args), this.maxValue.getStartMark());
        }
        if (this.style != null) {
            String symbolCompleted = null;
            String symbolRemaining = null;
            String colorCompleted = null;
            String colorRemaining = null;
            Integer length = null;
            String borderRight = null;
            String borderLeft = null;
            ImmutableMap colorCompletedSteps = null;
            Boolean colorRemainingFromColorCompleted = null;
            Boolean colorCurrentInterpolate = null;
            Boolean colorCompletedInterpolateSteps = null;
            switch (this.style.getValue()) {
                case "default": {
                    symbolCompleted = "\u258d";
                    symbolRemaining = "\u258d";
                    colorCompleted = "&a";
                    colorRemaining = "&8";
                    length = 16;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "largediv": {
                    symbolCompleted = "\u2589";
                    symbolRemaining = "\u2589";
                    colorCompleted = "&a";
                    colorRemaining = "&8";
                    length = 8;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "tricolor": {
                    symbolCompleted = "\u258d";
                    symbolRemaining = "\u258d";
                    colorCompletedSteps = ImmutableMap.of((Object)new MarkedIntegerProperty(0), (Object)new MarkedStringProperty("&a"), (Object)new MarkedIntegerProperty(60), (Object)new MarkedStringProperty("&e"), (Object)new MarkedIntegerProperty(80), (Object)new MarkedStringProperty("&c"));
                    colorRemaining = "&8";
                    length = 16;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "default_shaded": {
                    symbolCompleted = "\u258d";
                    symbolRemaining = "\u258d";
                    colorCompleted = "&a";
                    colorRemainingFromColorCompleted = true;
                    colorCurrentInterpolate = true;
                    length = 16;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "largediv_shaded": {
                    symbolCompleted = "\u2589";
                    symbolRemaining = "\u2589";
                    colorCompleted = "&a";
                    colorRemainingFromColorCompleted = true;
                    colorCurrentInterpolate = true;
                    length = 8;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "tricolor_shaded": {
                    symbolCompleted = "\u258d";
                    symbolRemaining = "\u258d";
                    colorCompletedSteps = ImmutableMap.of((Object)new MarkedIntegerProperty(0), (Object)new MarkedStringProperty("&a"), (Object)new MarkedIntegerProperty(50), (Object)new MarkedStringProperty("&a"), (Object)new MarkedIntegerProperty(75), (Object)new MarkedStringProperty("&e"), (Object)new MarkedIntegerProperty(100), (Object)new MarkedStringProperty("&c"));
                    colorCompletedInterpolateSteps = true;
                    colorRemainingFromColorCompleted = true;
                    colorCurrentInterpolate = true;
                    length = 16;
                    borderRight = "\u2523";
                    borderLeft = "\u252b";
                    break;
                }
                case "hearts": {
                    symbolCompleted = "\u2665";
                    symbolRemaining = "\u2665";
                    colorCompleted = "&c";
                    colorRemaining = "&8";
                    length = 10;
                    break;
                }
                default: {
                    tcc.getErrorHandler().addWarning("Unknown value '" + this.style.getValue() + "' for style option.", this.style.getStartMark());
                }
            }
            if (symbolCompleted != null && this.symbolCompleted == null) {
                this.symbolCompleted = new MarkedStringProperty(symbolCompleted);
            }
            if (symbolRemaining != null && this.symbolRemaining == null) {
                this.symbolRemaining = new MarkedStringProperty(symbolRemaining);
            }
            if (colorCompleted != null && this.colorCompleted == null && this.colorCompletedSteps == null) {
                this.colorCompleted = new MarkedStringProperty(colorCompleted);
            }
            if (colorRemaining != null && this.colorRemaining == null && this.colorRemainingSteps == null && this.colorRemainingFromColorCompleted == null) {
                this.colorRemaining = new MarkedStringProperty(colorRemaining);
            }
            if (length != null && this.length == null) {
                this.length = new MarkedIntegerProperty(length);
            }
            if (borderRight != null && this.borderRight == null) {
                this.borderRight = new MarkedStringProperty(borderRight);
            }
            if (borderLeft != null && this.borderLeft == null) {
                this.borderLeft = new MarkedStringProperty(borderLeft);
            }
            if (colorCompletedSteps != null && this.colorCompletedSteps == null && this.colorCompleted == null) {
                this.colorCompletedSteps = new MarkedMapProperty();
                this.colorCompletedSteps.putAll((Map<MarkedIntegerProperty, MarkedStringProperty>)colorCompletedSteps);
            }
            if (colorRemainingFromColorCompleted != null && this.colorRemaining == null && this.colorRemainingSteps == null && this.colorRemainingInterpolateSteps == null) {
                this.colorRemainingFromColorCompleted = new MarkedBooleanProperty(colorRemainingFromColorCompleted);
            }
            if (colorCurrentInterpolate != null && this.colorCurrent == null && this.colorCurrentInterpolate == null) {
                this.colorCurrentInterpolate = new MarkedBooleanProperty(colorCurrentInterpolate);
            }
            if (colorCompletedInterpolateSteps != null && this.colorCompletedInterpolateSteps == null) {
                this.colorCompletedInterpolateSteps = new MarkedBooleanProperty(colorCompletedInterpolateSteps);
            }
        }
        int length = 10;
        if (this.length != null && ConfigValidationUtil.checkRange(tcc, "!progress_bar custom placeholder", "length", this.length.getValue(), 0, 1000, this.length.getStartMark())) {
            length = this.length.getValue();
        }
        boolean symbolsSpecified = true;
        String symbolCompleted = "=";
        if (ConfigValidationUtil.checkNotNull(tcc, "!progress_bar custom placeholder", "symbolCompleted", this.symbolCompleted, this.getStartMark())) {
            symbolCompleted = this.replaceParameters(this.symbolCompleted.getValue(), args);
            if (!symbolCompleted.equals(ChatFormat.stripFormat(symbolCompleted))) {
                tcc.getErrorHandler().addWarning("symbolCompleted in !progress_bar should not contain format codes.", this.symbolCompleted.getStartMark());
                symbolsSpecified = false;
            }
        } else {
            symbolsSpecified = false;
        }
        String symbolRemaining = "=";
        if (ConfigValidationUtil.checkNotNull(tcc, "!progress_bar custom placeholder", "symbolRemaining", this.symbolRemaining, this.getStartMark())) {
            symbolRemaining = this.replaceParameters(this.symbolRemaining.getValue(), args);
            if (!symbolRemaining.equals(ChatFormat.stripFormat(symbolRemaining))) {
                tcc.getErrorHandler().addWarning("symbolRemaining in !progress_bar should not contain format codes.", this.symbolRemaining.getStartMark());
                symbolsSpecified = false;
            }
        } else {
            symbolsSpecified = false;
        }
        List<String> symbolsCurrent = Collections.singletonList(symbolCompleted);
        if (this.symbolCurrent != null && !((String)(symbolCurrent = this.replaceParameters(this.symbolCurrent.getValue(), args))).equals(ChatFormat.stripFormat((String)symbolCurrent))) {
            tcc.getErrorHandler().addWarning("symbolCurrent in !progress_bar should not contain format codes.", this.symbolCurrent.getStartMark());
            symbolsSpecified = false;
        }
        if (this.symbolCurrentSteps != null && ConfigValidationUtil.checkNotEmpty(tcc, "!progress_bar", "symbolCurrentSteps", this.symbolCurrentSteps, this.symbolCurrentSteps.getStartMark())) {
            if (this.symbolCurrent != null) {
                tcc.getErrorHandler().addWarning("In !progress_bar you cannot use the symbolCurrent and symbolCurrentSteps at the same time. Those are mutually exclusive.", this.symbolCurrentSteps.getStartMark());
            }
            symbolsCurrent = new ArrayList<String>();
            for (MarkedStringProperty symbol : this.symbolCurrentSteps) {
                if (symbol == null) continue;
                String s = this.replaceParameters(symbol.getValue(), args);
                if (!s.equals(ChatFormat.stripFormat(s))) {
                    tcc.getErrorHandler().addWarning("symbolCurrentSteps in !progress_bar should not contain format codes.", symbol.getStartMark());
                    symbolsSpecified = false;
                }
                symbolsCurrent.add(s);
            }
        }
        if (symbolsSpecified && ((double)(diff = (symbolCompletedLength = ChatFormat.formattedTextLength(symbolCompleted)) - ChatFormat.formattedTextLength(symbolRemaining)) < -0.1 || (double)diff > 0.1)) {
            tcc.getErrorHandler().addWarning("In !progress_bar symbolCompleted and symbolRemaining have different widths", this.getStartMark());
        }
        TextTemplate borderLeft = TextTemplate.EMPTY;
        if (this.borderLeft != null) {
            borderLeft = TextTemplate.parse(this.borderLeft.getValue(), this.borderLeft.getStartMark(), barContext);
        }
        TextTemplate borderRight = TextTemplate.EMPTY;
        if (this.borderRight != null) {
            borderRight = TextTemplate.parse(this.borderRight.getValue(), this.borderRight.getStartMark(), barContext);
        }
        TextTemplate textCenter = null;
        if (this.textCenter != null) {
            textCenter = TextTemplate.parse(this.textCenter.getValue(), this.textCenter.getStartMark(), barContext);
        }
        TextTemplate textCenterEmpty = null;
        if (this.textCenterEmpty != null) {
            textCenterEmpty = TextTemplate.parse(this.textCenterEmpty.getValue(), this.textCenterEmpty.getStartMark(), barContext);
        }
        TextTemplate textCenterFull = null;
        if (this.textCenterFull != null) {
            textCenterFull = TextTemplate.parse(this.textCenterFull.getValue(), this.textCenterFull.getStartMark(), barContext);
        }
        CustomPlaceholderProgressBar.BarColor colorCompleted = CustomPlaceholderProgressBar.BarColor.NONE;
        if (this.colorCompleted != null) {
            colorCompleted = new CustomPlaceholderProgressBar.ConstantBarColor(TextColor.parse(this.colorCompleted.getValue(), tcc, this.colorCompleted.getStartMark()));
        }
        if (this.colorCompletedSteps != null) {
            if (this.colorCompleted != null) {
                tcc.getErrorHandler().addWarning("In !progress_bar you cannot use the colorCompleted and colorCompletedSteps at the same time. Those are mutually exclusive.", this.colorCompleted.getStartMark());
            }
            int[] colorCompletedSteps = new int[this.colorCompletedSteps.size()];
            TextColor[] colorCompletedColors = new TextColor[this.colorCompletedSteps.size()];
            ArrayList list = new ArrayList(this.colorCompletedSteps.entrySet());
            list.sort(Comparator.comparingInt(entry -> ((MarkedIntegerProperty)entry.getKey()).getValue()));
            for (int i = 0; i < list.size(); ++i) {
                Map.Entry entry2 = list.get(i);
                colorCompletedSteps[i] = ((MarkedIntegerProperty)entry2.getKey()).getValue();
                colorCompletedColors[i] = TextColor.parse(((MarkedStringProperty)entry2.getValue()).getValue(), tcc, ((MarkedStringProperty)entry2.getValue()).getStartMark());
            }
            colorCompleted = this.colorCompletedInterpolateSteps == null || !this.colorCompletedInterpolateSteps.isValue() ? new CustomPlaceholderProgressBar.StepBarColor(colorCompletedSteps, colorCompletedColors) : new CustomPlaceholderProgressBar.InterpolateBarColor(colorCompletedSteps, colorCompletedColors);
        }
        TextColor colorCurrent = null;
        if (this.colorCurrent != null) {
            colorCurrent = TextColor.parse(this.colorCurrent.getValue(), tcc, this.colorCurrent.getStartMark());
        }
        boolean colorCurrentInterpolate = false;
        if (this.colorCurrentInterpolate != null) {
            colorCurrentInterpolate = this.colorCurrentInterpolate.isValue();
        }
        CustomPlaceholderProgressBar.BarColor colorRemaining = CustomPlaceholderProgressBar.BarColor.NONE;
        if (this.colorRemaining != null) {
            colorRemaining = new CustomPlaceholderProgressBar.ConstantBarColor(TextColor.parse(this.colorRemaining.getValue(), tcc, this.colorRemaining.getStartMark()));
        }
        if (this.colorRemainingSteps != null) {
            if (this.colorRemaining != null) {
                tcc.getErrorHandler().addWarning("In !progress_bar you cannot use the colorRemaining and colorRemainingSteps at the same time. Those are mutually exclusive.", this.colorRemaining.getStartMark());
            }
            int[] colorRemainingSteps = new int[this.colorRemainingSteps.size()];
            TextColor[] colorRemainingColors = new TextColor[this.colorRemainingSteps.size()];
            ArrayList list = new ArrayList(this.colorRemainingSteps.entrySet());
            list.sort(Comparator.comparingInt(entry -> ((MarkedIntegerProperty)entry.getKey()).getValue()));
            for (int i = 0; i < list.size(); ++i) {
                Map.Entry entry3 = list.get(i);
                colorRemainingSteps[i] = ((MarkedIntegerProperty)entry3.getKey()).getValue();
                colorRemainingColors[i] = TextColor.parse(((MarkedStringProperty)entry3.getValue()).getValue(), tcc, ((MarkedStringProperty)entry3.getValue()).getStartMark());
            }
            colorRemaining = this.colorRemainingInterpolateSteps == null || !this.colorRemainingInterpolateSteps.isValue() ? new CustomPlaceholderProgressBar.StepBarColor(colorRemainingSteps, colorRemainingColors) : new CustomPlaceholderProgressBar.InterpolateBarColor(colorRemainingSteps, colorRemainingColors);
        }
        if (this.colorRemainingFromColorCompleted != null && this.colorRemainingFromColorCompleted.isValue()) {
            if (this.colorRemaining != null) {
                tcc.getErrorHandler().addWarning("In !progress_bar you cannot use the colorRemaining and colorRemainingFromColorCompleted at the same time. Those are mutually exclusive.", this.colorRemaining.getStartMark());
            }
            if (this.colorRemainingSteps != null) {
                tcc.getErrorHandler().addWarning("In !progress_bar you cannot use the colorRemainingSteps and colorRemainingFromColorCompleted at the same time. Those are mutually exclusive.", this.colorRemaining.getStartMark());
            }
            colorRemaining = new CustomPlaceholderProgressBar.DarkerBarColor(colorCompleted);
        }
        TextColor colorEmptyBar = null;
        if (this.colorEmptyBar != null) {
            colorEmptyBar = TextColor.parse(this.colorEmptyBar.getValue(), tcc, this.colorEmptyBar.getStartMark());
        }
        TextColor colorFullBar = null;
        if (this.colorFullBar != null) {
            colorFullBar = TextColor.parse(this.colorFullBar.getValue(), tcc, this.colorFullBar.getStartMark());
        }
        boolean emptyBarShowSymbols = true;
        if (this.emptyBarShowSymbols != null) {
            emptyBarShowSymbols = this.emptyBarShowSymbols.isValue();
        }
        boolean fullBarShowSymbols = true;
        if (this.fullBarShowSymbols != null) {
            fullBarShowSymbols = this.fullBarShowSymbols.isValue();
        }
        TextTemplate emptyBar = null;
        if (this.emptyBar != null) {
            emptyBar = TextTemplate.parse(this.emptyBar.getValue(), this.emptyBar.getStartMark(), barContext);
        }
        TextTemplate fullBar = null;
        if (this.fullBar != null) {
            fullBar = TextTemplate.parse(this.fullBar.getValue(), this.fullBar.getStartMark(), barContext);
        }
        ExpressionTemplate finalValue = value;
        ExpressionTemplate finalMinValue = minValue;
        ExpressionTemplate finalMaxValue = maxValue;
        int finalLength = length;
        String finalSymbolCompleted = symbolCompleted;
        String finalSymbolRemaining = symbolRemaining;
        List<String> finalSymbolsCurrent = symbolsCurrent;
        TextTemplate finalBorderLeft = borderLeft;
        TextTemplate finalBorderRight = borderRight;
        TextTemplate finalTextCenter = textCenter;
        TextTemplate finalTextCenterEmpty = textCenterEmpty;
        TextTemplate finalTextCenterFull = textCenterFull;
        CustomPlaceholderProgressBar.BarColor finalColorCompleted = colorCompleted;
        TextColor finalColorCurrent = colorCurrent;
        boolean finalColorCurrentInterpolate = colorCurrentInterpolate;
        CustomPlaceholderProgressBar.BarColor finalColorRemaining = colorRemaining;
        TextColor finalColorEmptyBar = colorEmptyBar;
        TextColor finalColorFullBar = colorFullBar;
        boolean finalEmptyBarShowSymbols = emptyBarShowSymbols;
        boolean finalFullBarShowSymbols = fullBarShowSymbols;
        TextTemplate finalEmptyBar = emptyBar;
        TextTemplate finalFullBar = fullBar;
        return builder.acquireData(() -> new CustomPlaceholderProgressBar(finalValue, finalMinValue, finalMaxValue, finalLength, finalSymbolCompleted, finalSymbolRemaining, finalSymbolsCurrent, finalBorderLeft, finalBorderRight, finalTextCenter, finalTextCenterEmpty, finalTextCenterFull, finalColorCompleted, finalColorCurrent, finalColorCurrentInterpolate, finalColorRemaining, finalColorEmptyBar, finalColorFullBar, finalEmptyBarShowSymbols, finalFullBarShowSymbols, finalEmptyBar, finalFullBar), TypeToken.STRING, true);
    }

    public MarkedStringProperty getValue() {
        return this.value;
    }

    public MarkedStringProperty getMinValue() {
        return this.minValue;
    }

    public MarkedStringProperty getMaxValue() {
        return this.maxValue;
    }

    public MarkedStringProperty getStyle() {
        return this.style;
    }

    public MarkedIntegerProperty getLength() {
        return this.length;
    }

    public MarkedStringProperty getSymbolCompleted() {
        return this.symbolCompleted;
    }

    public MarkedStringProperty getSymbolRemaining() {
        return this.symbolRemaining;
    }

    public MarkedStringProperty getSymbolCurrent() {
        return this.symbolCurrent;
    }

    public MarkedListProperty<MarkedStringProperty> getSymbolCurrentSteps() {
        return this.symbolCurrentSteps;
    }

    public MarkedStringProperty getBorderLeft() {
        return this.borderLeft;
    }

    public MarkedStringProperty getBorderRight() {
        return this.borderRight;
    }

    public MarkedStringProperty getTextCenter() {
        return this.textCenter;
    }

    public MarkedStringProperty getTextCenterEmpty() {
        return this.textCenterEmpty;
    }

    public MarkedStringProperty getTextCenterFull() {
        return this.textCenterFull;
    }

    public MarkedStringProperty getColorCompleted() {
        return this.colorCompleted;
    }

    public MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> getColorCompletedSteps() {
        return this.colorCompletedSteps;
    }

    public MarkedBooleanProperty getColorCompletedInterpolateSteps() {
        return this.colorCompletedInterpolateSteps;
    }

    public MarkedStringProperty getColorCurrent() {
        return this.colorCurrent;
    }

    public MarkedBooleanProperty getColorCurrentInterpolate() {
        return this.colorCurrentInterpolate;
    }

    public MarkedStringProperty getColorRemaining() {
        return this.colorRemaining;
    }

    public MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> getColorRemainingSteps() {
        return this.colorRemainingSteps;
    }

    public MarkedBooleanProperty getColorRemainingInterpolateSteps() {
        return this.colorRemainingInterpolateSteps;
    }

    public MarkedBooleanProperty getColorRemainingFromColorCompleted() {
        return this.colorRemainingFromColorCompleted;
    }

    public MarkedStringProperty getColorEmptyBar() {
        return this.colorEmptyBar;
    }

    public MarkedStringProperty getColorFullBar() {
        return this.colorFullBar;
    }

    public MarkedBooleanProperty getEmptyBarShowSymbols() {
        return this.emptyBarShowSymbols;
    }

    public MarkedBooleanProperty getFullBarShowSymbols() {
        return this.fullBarShowSymbols;
    }

    public MarkedStringProperty getEmptyBar() {
        return this.emptyBar;
    }

    public MarkedStringProperty getFullBar() {
        return this.fullBar;
    }

    public void setValue(MarkedStringProperty value) {
        this.value = value;
    }

    public void setMinValue(MarkedStringProperty minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(MarkedStringProperty maxValue) {
        this.maxValue = maxValue;
    }

    public void setStyle(MarkedStringProperty style) {
        this.style = style;
    }

    public void setLength(MarkedIntegerProperty length) {
        this.length = length;
    }

    public void setSymbolCompleted(MarkedStringProperty symbolCompleted) {
        this.symbolCompleted = symbolCompleted;
    }

    public void setSymbolRemaining(MarkedStringProperty symbolRemaining) {
        this.symbolRemaining = symbolRemaining;
    }

    public void setSymbolCurrent(MarkedStringProperty symbolCurrent) {
        this.symbolCurrent = symbolCurrent;
    }

    public void setSymbolCurrentSteps(MarkedListProperty<MarkedStringProperty> symbolCurrentSteps) {
        this.symbolCurrentSteps = symbolCurrentSteps;
    }

    public void setBorderLeft(MarkedStringProperty borderLeft) {
        this.borderLeft = borderLeft;
    }

    public void setBorderRight(MarkedStringProperty borderRight) {
        this.borderRight = borderRight;
    }

    public void setTextCenter(MarkedStringProperty textCenter) {
        this.textCenter = textCenter;
    }

    public void setTextCenterEmpty(MarkedStringProperty textCenterEmpty) {
        this.textCenterEmpty = textCenterEmpty;
    }

    public void setTextCenterFull(MarkedStringProperty textCenterFull) {
        this.textCenterFull = textCenterFull;
    }

    public void setColorCompleted(MarkedStringProperty colorCompleted) {
        this.colorCompleted = colorCompleted;
    }

    public void setColorCompletedSteps(MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> colorCompletedSteps) {
        this.colorCompletedSteps = colorCompletedSteps;
    }

    public void setColorCompletedInterpolateSteps(MarkedBooleanProperty colorCompletedInterpolateSteps) {
        this.colorCompletedInterpolateSteps = colorCompletedInterpolateSteps;
    }

    public void setColorCurrent(MarkedStringProperty colorCurrent) {
        this.colorCurrent = colorCurrent;
    }

    public void setColorCurrentInterpolate(MarkedBooleanProperty colorCurrentInterpolate) {
        this.colorCurrentInterpolate = colorCurrentInterpolate;
    }

    public void setColorRemaining(MarkedStringProperty colorRemaining) {
        this.colorRemaining = colorRemaining;
    }

    public void setColorRemainingSteps(MarkedMapProperty<MarkedIntegerProperty, MarkedStringProperty> colorRemainingSteps) {
        this.colorRemainingSteps = colorRemainingSteps;
    }

    public void setColorRemainingInterpolateSteps(MarkedBooleanProperty colorRemainingInterpolateSteps) {
        this.colorRemainingInterpolateSteps = colorRemainingInterpolateSteps;
    }

    public void setColorRemainingFromColorCompleted(MarkedBooleanProperty colorRemainingFromColorCompleted) {
        this.colorRemainingFromColorCompleted = colorRemainingFromColorCompleted;
    }

    public void setColorEmptyBar(MarkedStringProperty colorEmptyBar) {
        this.colorEmptyBar = colorEmptyBar;
    }

    public void setColorFullBar(MarkedStringProperty colorFullBar) {
        this.colorFullBar = colorFullBar;
    }

    public void setEmptyBarShowSymbols(MarkedBooleanProperty emptyBarShowSymbols) {
        this.emptyBarShowSymbols = emptyBarShowSymbols;
    }

    public void setFullBarShowSymbols(MarkedBooleanProperty fullBarShowSymbols) {
        this.fullBarShowSymbols = fullBarShowSymbols;
    }

    public void setEmptyBar(MarkedStringProperty emptyBar) {
        this.emptyBar = emptyBar;
    }

    public void setFullBar(MarkedStringProperty fullBar) {
        this.fullBar = fullBar;
    }
}

