/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderConditional;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.List;

public class CustomPlaceholderConditionalConfiguration
extends CustomPlaceholderConfiguration {
    private MarkedStringProperty condition;
    private MarkedStringProperty trueReplacement;
    private MarkedStringProperty falseReplacement;

    public MarkedStringProperty getTrue() {
        return this.trueReplacement;
    }

    public void setTrue(MarkedStringProperty trueReplacement) {
        this.trueReplacement = trueReplacement;
    }

    public MarkedStringProperty getFalse() {
        return this.falseReplacement;
    }

    public void setFalse(MarkedStringProperty falseReplacement) {
        this.falseReplacement = falseReplacement;
    }

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        ExpressionTemplate compiledCondition = ConstantExpressionTemplate.of(true);
        if (ConfigValidationUtil.checkNotNull(tcc, "custom placeholder !conditional", "condition", this.condition, this.getStartMark())) {
            try {
                compiledCondition = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(this.condition.getValue(), args), this.condition.getStartMark());
            }
            catch (Exception e) {
                tcc.getErrorHandler().addError("Failed to compile condition for custom placeholder. " + e.getMessage(), this.condition.getStartMark());
            }
        }
        if (this.trueReplacement == null && this.falseReplacement == null) {
            tcc.getErrorHandler().addWarning("No replacements configured for conditional custom placeholder.", this.getStartMark());
        }
        TextTemplate trueReplacement = TextTemplate.EMPTY;
        try {
            trueReplacement = this.trueReplacement != null ? TextTemplate.parse(this.replaceParameters(this.trueReplacement.getValue(), args), this.trueReplacement.getStartMark(), tcc) : TextTemplate.EMPTY;
        }
        catch (Exception e) {
            tcc.getErrorHandler().addError("Failed to parse true replacement for custom placeholder: " + e.getMessage(), this.trueReplacement.getStartMark());
        }
        TextTemplate falseReplacement = TextTemplate.EMPTY;
        try {
            falseReplacement = this.falseReplacement != null ? TextTemplate.parse(this.replaceParameters(this.falseReplacement.getValue(), args), this.falseReplacement.getStartMark(), tcc) : TextTemplate.EMPTY;
        }
        catch (Exception e) {
            tcc.getErrorHandler().addError("Failed to parse false replacement for custom placeholder: " + e.getMessage(), this.falseReplacement.getStartMark());
        }
        ExpressionTemplate finalCompiledCondition = compiledCondition;
        TextTemplate finalTrueReplacement = trueReplacement;
        TextTemplate finalFalseReplacement = falseReplacement;
        return builder.acquireData(() -> new CustomPlaceholderConditional(finalCompiledCondition, finalTrueReplacement, finalFalseReplacement), TypeToken.STRING, finalCompiledCondition.requiresViewerContext() || finalTrueReplacement.requiresViewerContext() || finalFalseReplacement.requiresViewerContext());
    }

    public MarkedStringProperty getCondition() {
        return this.condition;
    }

    public void setCondition(MarkedStringProperty condition) {
        this.condition = condition;
    }
}

