/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderCompute;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.List;

public class CustomPlaceholderComputeConfiguration
extends CustomPlaceholderConfiguration {
    private MarkedStringProperty expression;
    private transient boolean needToFixMark;

    public CustomPlaceholderComputeConfiguration(String text) {
        if (text != null) {
            this.expression = new MarkedStringProperty(text);
        }
        this.needToFixMark = true;
    }

    @Override
    public void setStartMark(Mark startMark) {
        super.setStartMark(startMark);
        if (this.needToFixMark) {
            this.expression.setStartMark(startMark);
        }
    }

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        ExpressionTemplate compiledExpression = ConstantExpressionTemplate.of("");
        if (ConfigValidationUtil.checkNotNull(tcc, "custom placeholder !compute", "expression", this.expression, this.getStartMark())) {
            try {
                compiledExpression = tcc.getExpressionEngine().compile(tcc, this.replaceParameters(this.expression.getValue(), args), this.expression.getStartMark());
            }
            catch (Exception e) {
                tcc.getErrorHandler().addError("Failed to compile condition for custom placeholder. " + e.getMessage(), this.expression.getStartMark());
            }
        }
        ConstantExpressionTemplate finalCompiledExpression = compiledExpression;
        return builder.acquireData(() -> new CustomPlaceholderCompute(finalCompiledExpression), TypeToken.DOUBLE, finalCompiledExpression.requiresViewerContext());
    }

    public CustomPlaceholderComputeConfiguration() {
    }

    public MarkedStringProperty getExpression() {
        return this.expression;
    }

    public void setExpression(MarkedStringProperty expression) {
        this.expression = expression;
    }
}

