/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedFloatProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedListProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.misc.TextColor;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationGlitter;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationRainbow;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationRandom;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationUniformRainbow;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationWave;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderColorAnimationWaveCenter;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;

public class CustomPlaceholderColorAnimationConfiguration
extends CustomPlaceholderConfiguration {
    private MarkedStringProperty effect;
    private MarkedListProperty<MarkedStringProperty> colors;
    private MarkedStringProperty baseColor;
    private MarkedStringProperty effectColor;
    private MarkedIntegerProperty distance;
    private MarkedFloatProperty speed;
    private MarkedStringProperty formats;

    public CustomPlaceholderColorAnimationConfiguration() {
        this.setParameters(new MarkedIntegerProperty(1));
    }

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        String effect;
        String string = effect = this.effect != null ? this.effect.getValue() : null;
        if (effect == null) {
            effect = "rainbow";
        }
        boolean requireColors = false;
        boolean requireBaseColor = false;
        boolean requireEffectColor = false;
        switch (effect) {
            case "uniformRainbow": 
            case "rainbow": 
            case "random": {
                requireColors = true;
                break;
            }
            case "wave": 
            case "waveCenter": 
            case "glitter": {
                requireBaseColor = true;
                requireEffectColor = true;
                break;
            }
            default: {
                tcc.getErrorHandler().addWarning("Unknown effect in !color_animation custom placeholder", this.effect.getStartMark());
            }
        }
        ArrayList<TextColor> colors = new ArrayList<TextColor>();
        if (requireColors && ConfigValidationUtil.checkNotNull(tcc, "!color_animation custom placeholder", "colors", this.colors, this.getStartMark()) && ConfigValidationUtil.checkNotEmpty(tcc, "!color_animation custom placeholder", "colors", this.colors, this.colors.getStartMark())) {
            for (MarkedStringProperty color : this.colors) {
                if (color == null) continue;
                colors.add(TextColor.parse(color.getValue(), tcc, color.getStartMark()));
            }
        }
        TextColor baseColor = TextColor.COLOR_BLACK;
        if (requireBaseColor && ConfigValidationUtil.checkNotNull(tcc, "!color_animation custom placeholder", "baseColor", this.baseColor, this.getStartMark()) && ConfigValidationUtil.checkNotNull(tcc, "!color_animation custom placeholder", "baseColor", this.baseColor.getValue(), this.baseColor.getStartMark())) {
            baseColor = TextColor.parse(this.baseColor.getValue(), tcc, this.baseColor.getStartMark());
        }
        TextColor effectColor = TextColor.COLOR_BLACK;
        if (requireEffectColor && ConfigValidationUtil.checkNotNull(tcc, "!color_animation custom placeholder", "effectColor", this.effectColor, this.getStartMark()) && ConfigValidationUtil.checkNotNull(tcc, "!color_animation custom placeholder", "effectColor", this.effectColor.getValue(), this.effectColor.getStartMark())) {
            effectColor = TextColor.parse(this.effectColor.getValue(), tcc, this.effectColor.getStartMark());
        }
        OptionalInt distance = OptionalInt.empty();
        if (this.distance != null) {
            distance = OptionalInt.of(this.distance.getValue());
        }
        float speed = 2.0f;
        if (this.speed != null) {
            speed = this.speed.getValue();
        }
        TextTemplate textTemplate = TextTemplate.parse(this.replaceParameters("%0", args), this.getStartMark(), tcc);
        OptionalInt finalDistance = distance;
        float finalSpeed = speed;
        TextColor finalBaseColor = baseColor;
        TextColor finalEffectColor = effectColor;
        String finalFormats = this.formats == null ? "" : CustomPlaceholderColorAnimationConfiguration.sanitizeFormats(this.formats.getValue());
        switch (effect) {
            case "rainbow": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationRainbow(textTemplate, colors, finalFormats, finalDistance, finalSpeed), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
            case "random": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationRandom(textTemplate, colors, finalFormats), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
            case "wave": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationWave(textTemplate, finalBaseColor, finalEffectColor, finalSpeed, finalFormats), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
            case "waveCenter": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationWaveCenter(textTemplate, finalBaseColor, finalEffectColor, finalSpeed, finalFormats), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
            case "glitter": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationGlitter(textTemplate, finalBaseColor, finalEffectColor, finalFormats), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
            case "uniformRainbow": {
                return builder.acquireData(() -> new CustomPlaceholderColorAnimationUniformRainbow(textTemplate, colors, finalDistance, finalSpeed, finalFormats), TypeToken.STRING, textTemplate.requiresViewerContext());
            }
        }
        return builder;
    }

    private static String sanitizeFormats(String formats) {
        if (formats == null) {
            return "";
        }
        char[] chars = formats.toCharArray();
        StringBuilder sb = new StringBuilder(formats.length());
        for (int i = 0; i < chars.length; ++i) {
            char code;
            char c = chars[i];
            if (c != '&' || i++ >= chars.length || (code = Character.toLowerCase(chars[i])) != 'l' && code != 'm' && code != 'n' && code != 'o' && code != 'k') continue;
            sb.append(c).append(code);
        }
        return sb.toString();
    }

    public MarkedStringProperty getEffect() {
        return this.effect;
    }

    public void setEffect(MarkedStringProperty effect) {
        this.effect = effect;
    }

    public MarkedListProperty<MarkedStringProperty> getColors() {
        return this.colors;
    }

    public void setColors(MarkedListProperty<MarkedStringProperty> colors) {
        this.colors = colors;
    }

    public MarkedStringProperty getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(MarkedStringProperty baseColor) {
        this.baseColor = baseColor;
    }

    public MarkedStringProperty getEffectColor() {
        return this.effectColor;
    }

    public void setEffectColor(MarkedStringProperty effectColor) {
        this.effectColor = effectColor;
    }

    public MarkedIntegerProperty getDistance() {
        return this.distance;
    }

    public void setDistance(MarkedIntegerProperty distance) {
        this.distance = distance;
    }

    public MarkedFloatProperty getSpeed() {
        return this.speed;
    }

    public void setSpeed(MarkedFloatProperty speed) {
        this.speed = speed;
    }

    public MarkedStringProperty getFormats() {
        return this.formats;
    }

    public void setFormats(MarkedStringProperty formats) {
        this.formats = formats;
    }
}

