/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.customplaceholder;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedFloatProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedListProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderAnimated;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.util.ArrayList;
import java.util.List;

public class CustomPlaceholderAnimatedConfiguration
extends CustomPlaceholderConfiguration {
    private MarkedListProperty<MarkedStringProperty> elements;
    private MarkedFloatProperty interval;
    private boolean randomize = false;

    @Override
    public PlaceholderBuilder<?, ?> bindArgs(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        ArrayList<TextTemplate> elementTemplates = new ArrayList<TextTemplate>(this.elements.size());
        if ((ConfigValidationUtil.checkNotNull(tcc, "!animated custom placeholder", "elements", this.elements, this.getStartMark()) && ConfigValidationUtil.checkNotEmpty(tcc, "!animated custom placeholder", "elements", this.elements, this.elements.getStartMark())) & ConfigValidationUtil.checkNotNull(tcc, "!animated custom placeholder", "interval", this.interval, this.getStartMark()) && ConfigValidationUtil.checkRange(tcc, "!animated custom placeholder", "interval", this.interval.getValue(), 0.05f, 9999.0f, this.interval.getStartMark())) {
            for (MarkedStringProperty element : this.elements) {
                if (element == null) {
                    elementTemplates.add(TextTemplate.EMPTY);
                    continue;
                }
                elementTemplates.add(TextTemplate.parse(this.replaceParameters(element.getValue(), args), element.getStartMark(), tcc));
            }
        }
        return builder.acquireData(() -> new CustomPlaceholderAnimated(elementTemplates, this.interval.getValue(), this.randomize), TypeToken.STRING, elementTemplates.stream().anyMatch(TextTemplate::requiresViewerContext));
    }

    public MarkedListProperty<MarkedStringProperty> getElements() {
        return this.elements;
    }

    public void setElements(MarkedListProperty<MarkedStringProperty> elements) {
        this.elements = elements;
    }

    public MarkedFloatProperty getInterval() {
        return this.interval;
    }

    public void setInterval(MarkedFloatProperty interval) {
        this.interval = interval;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }
}

