/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import com.google.common.collect.ImmutableList;
import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedMapProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.TableComponentTemplate;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public class TableComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private MarkedIntegerProperty size = new MarkedIntegerProperty(-1);
    private MarkedMapProperty<MarkedStringProperty, ComponentConfiguration> columns = new MarkedMapProperty();

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        OptionalInt columnsCount = tcc.getColumns();
        if (!columnsCount.isPresent()) {
            tcc.getErrorHandler().addError("table component cannot be used in dynamic size tab lists", this.getStartMark());
            return tcc.emptyComponent();
        }
        if (this.size == null) {
            this.size = new MarkedIntegerProperty(-1);
        }
        if (this.size.getValue() < -1) {
            tcc.getErrorHandler().addError("Failed to configure table component. Size is negative", this.size.getStartMark());
        } else if (this.size.getValue() != -1 && this.size.getValue() % columnsCount.getAsInt() != 0) {
            tcc.getErrorHandler().addError("Failed to configure table component. Size is not a multiple of " + columnsCount.getAsInt(), this.size.getStartMark());
        }
        ImmutableList.Builder columnList = ImmutableList.builder();
        if (ConfigValidationUtil.checkNotNull(tcc, "!table component", "columns", this.columns, this.getStartMark())) {
            int nextAvailableColumnIndex = 0;
            for (Map.Entry entry : this.columns.entrySet()) {
                if (entry.getKey() == null) continue;
                String key = ((MarkedStringProperty)entry.getKey()).getValue();
                try {
                    int width;
                    int columnIndex;
                    if (key.contains("-")) {
                        String[] tokens = key.split("-");
                        columnIndex = Integer.valueOf(tokens[0]);
                        width = Integer.valueOf(tokens[1]) - columnIndex + 1;
                    } else {
                        columnIndex = Integer.valueOf(key);
                        width = 1;
                    }
                    if (columnIndex < nextAvailableColumnIndex) {
                        tcc.getErrorHandler().addError("Failed to configure table component. Columns not ordered", ((MarkedStringProperty)entry.getKey()).getStartMark());
                        continue;
                    }
                    if (width < 1) {
                        tcc.getErrorHandler().addError("Failed to configure table component. Column has illegal width", ((MarkedStringProperty)entry.getKey()).getStartMark());
                        continue;
                    }
                    if (columnIndex + width > columnsCount.getAsInt()) {
                        tcc.getErrorHandler().addError("Failed to configure table component. Column outside the tab overlay (available columns here: 0-" + (columnsCount.getAsInt() - 1) + ").", ((MarkedStringProperty)entry.getKey()).getStartMark());
                        continue;
                    }
                    ComponentConfiguration component = (ComponentConfiguration)entry.getValue();
                    TemplateCreationContext childContext = tcc.clone();
                    childContext.setColumns(width);
                    columnList.add((Object)TableComponentTemplate.Column.builder().columnIndex(columnIndex).width(width).component(component != null ? component.toTemplate(childContext) : tcc.emptyComponent()).build());
                }
                catch (NumberFormatException e) {
                    tcc.getErrorHandler().addError("Failed to configure table component. Failed to parse column key: " + e.getMessage(), ((MarkedStringProperty)entry.getKey()).getStartMark());
                }
            }
        }
        return TableComponentTemplate.builder().size(this.size.getValue()).columns((List<TableComponentTemplate.Column>)columnList.build()).columnCount(columnsCount.getAsInt()).defaultIcon(tcc.getDefaultIcon()).defaultText(tcc.getDefaultText()).defaultPing(tcc.getDefaultPing()).build();
    }

    public MarkedIntegerProperty getSize() {
        return this.size;
    }

    public MarkedMapProperty<MarkedStringProperty, ComponentConfiguration> getColumns() {
        return this.columns;
    }

    public void setSize(MarkedIntegerProperty size) {
        this.size = size;
    }

    public void setColumns(MarkedMapProperty<MarkedStringProperty, ComponentConfiguration> columns) {
        this.columns = columns;
    }
}

