/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.PlayerOrderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.BasicComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.placeholder.OtherCountPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.PlayersComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.PlayerIconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PlayerPingTemplate;
import javax.annotation.Nullable;

public class PlayersComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private PlayerOrderConfiguration playerOrder = PlayerOrderConfiguration.DEFAULT;
    private MarkedStringProperty playerSet = null;
    private ComponentConfiguration playerComponent = new BasicComponentConfiguration("${player name}");
    @Nullable
    private ComponentConfiguration morePlayersComponent = null;
    private boolean fillSlotsVertical = false;
    private MarkedIntegerProperty minSize = new MarkedIntegerProperty(0);
    private MarkedIntegerProperty maxSize = new MarkedIntegerProperty(-1);

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        ComponentTemplate morePlayersComponentTemplate;
        if (ConfigValidationUtil.checkNotNull(tcc, "!players component", "playerSet", this.playerSet, this.getStartMark()) && !tcc.getPlayerSets().containsKey(this.playerSet.getValue())) {
            tcc.getErrorHandler().addError("No player set definition available for player set \"" + this.playerSet.getValue() + "\"", this.playerSet.getStartMark());
        }
        PlayerOrderTemplate playerOrderTemplate = PlayerOrderConfiguration.DEFAULT.toTemplate(tcc);
        if (ConfigValidationUtil.checkNotNull(tcc, "!players component", "playerOrder", this.playerOrder, this.getStartMark())) {
            playerOrderTemplate = this.playerOrder.toTemplate(tcc);
        }
        if (this.minSize.getValue() < 0) {
            tcc.getErrorHandler().addError("Failed to configure players component. MinSize is negative", this.minSize.getStartMark());
        }
        if (this.maxSize.getValue() != -1 && this.minSize.getValue() > this.maxSize.getValue()) {
            tcc.getErrorHandler().addError("Failed to configure players component. MaxSize is lower than minSize", this.maxSize.getStartMark());
        }
        TemplateCreationContext childContextP = tcc.clone();
        childContextP.setDefaultIcon(new PlayerIconTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerIconDataKey()));
        childContextP.setDefaultPing(new PlayerPingTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerPingDataKey()));
        childContextP.setPlayerAvailable(true);
        TemplateCreationContext childContextM = tcc.clone();
        childContextM.addPlaceholderResolver(new OtherCountPlaceholderResolver());
        ComponentTemplate playerComponentTemplate = tcc.emptyComponent();
        if (ConfigValidationUtil.checkNotNull(tcc, "!players component", "playerComponent", this.playerComponent, this.getStartMark())) {
            playerComponentTemplate = this.playerComponent.toTemplate(childContextP);
            ComponentTemplate.LayoutInfo layoutInfo = playerComponentTemplate.getLayoutInfo();
            if (!layoutInfo.isConstantSize()) {
                tcc.getErrorHandler().addError("Failed to configure !players component. Attribute playerComponent must not have variable size.", this.playerComponent.getStartMark());
            }
            if (layoutInfo.isBlockAligned()) {
                tcc.getErrorHandler().addError("Failed to configure !players component. Attribute playerComponent must not require block alignment.", this.playerComponent.getStartMark());
            }
        }
        if (this.morePlayersComponent != null) {
            morePlayersComponentTemplate = this.morePlayersComponent.toTemplate(childContextM);
            ComponentTemplate.LayoutInfo layoutInfo = morePlayersComponentTemplate.getLayoutInfo();
            if (!layoutInfo.isConstantSize()) {
                tcc.getErrorHandler().addError("Failed to configure !players component. Attribute playerComponent cannot have variable size.", this.morePlayersComponent.getStartMark());
            }
            if (layoutInfo.isBlockAligned()) {
                tcc.getErrorHandler().addError("Failed to configure !players component. Attribute playerComponent must not require block alignment.", this.morePlayersComponent.getStartMark());
            }
        } else {
            morePlayersComponentTemplate = childContextM.emptyComponent();
        }
        return PlayersComponentTemplate.builder().playerOrder(playerOrderTemplate).playerSet(tcc.getPlayerSets().get(this.playerSet.getValue())).playerComponent(playerComponentTemplate).morePlayersComponent(morePlayersComponentTemplate).fillSlotsVertical(this.fillSlotsVertical).minSize(this.minSize.getValue()).maxSize(this.maxSize.getValue()).columns(tcc.getColumns().orElse(1)).defaultIcon(tcc.getDefaultIcon()).defaultText(tcc.getDefaultText()).defaultPing(tcc.getDefaultPing()).build();
    }

    public PlayerOrderConfiguration getPlayerOrder() {
        return this.playerOrder;
    }

    public MarkedStringProperty getPlayerSet() {
        return this.playerSet;
    }

    public ComponentConfiguration getPlayerComponent() {
        return this.playerComponent;
    }

    @Nullable
    public ComponentConfiguration getMorePlayersComponent() {
        return this.morePlayersComponent;
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public MarkedIntegerProperty getMinSize() {
        return this.minSize;
    }

    public MarkedIntegerProperty getMaxSize() {
        return this.maxSize;
    }

    public void setPlayerOrder(PlayerOrderConfiguration playerOrder) {
        this.playerOrder = playerOrder;
    }

    public void setPlayerSet(MarkedStringProperty playerSet) {
        this.playerSet = playerSet;
    }

    public void setPlayerComponent(ComponentConfiguration playerComponent) {
        this.playerComponent = playerComponent;
    }

    public void setMorePlayersComponent(@Nullable ComponentConfiguration morePlayersComponent) {
        this.morePlayersComponent = morePlayersComponent;
    }

    public void setFillSlotsVertical(boolean fillSlotsVertical) {
        this.fillSlotsVertical = fillSlotsVertical;
    }

    public void setMinSize(MarkedIntegerProperty minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(MarkedIntegerProperty maxSize) {
        this.maxSize = maxSize;
    }
}

