/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.ListComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ContainerComponentTemplate;
import java.util.List;

public class ContainerComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private boolean fillSlotsVertical = false;
    MarkedIntegerProperty minSize;
    MarkedIntegerProperty maxSize;
    private ListComponentConfiguration components;

    public List<ComponentConfiguration> getComponents() {
        throw new UnsupportedOperationException("dummy method");
    }

    public void setComponents(List<ComponentConfiguration> components) {
        this.components = new ListComponentConfiguration();
        this.components.addAll(components);
    }

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        TemplateCreationContext childContext;
        if (this.minSize != null && this.minSize.getValue() < 0) {
            tcc.getErrorHandler().addError("Failed to configure container component. MinSize is negative", this.minSize.getStartMark());
        }
        if (this.maxSize != null && (this.minSize != null ? this.minSize.getValue() : 0) > this.maxSize.getValue()) {
            tcc.getErrorHandler().addError("Failed to configure container component. MaxSize is lower than minSize", this.maxSize.getStartMark());
        }
        if (this.fillSlotsVertical) {
            childContext = tcc.clone();
            childContext.setColumns(1);
        } else {
            childContext = tcc;
        }
        ComponentTemplate content = tcc.emptyComponent();
        if (ConfigValidationUtil.checkNotNull(tcc, "!container component", "components", this.components, this.getStartMark())) {
            content = this.components.toTemplate(childContext);
        }
        int contentMinSize = content.getLayoutInfo().getMinSize();
        if (this.maxSize != null && contentMinSize > this.maxSize.getValue()) {
            tcc.getErrorHandler().addWarning("maxSize of !container set to " + this.maxSize.getValue() + " but content will require at least " + contentMinSize + " slots.", this.maxSize.getStartMark());
        }
        return ContainerComponentTemplate.builder().content(content).fillSlotsVertical(this.fillSlotsVertical).minSize(this.minSize != null ? this.minSize.getValue() : 0).maxSize(this.maxSize != null ? this.maxSize.getValue() : -1).columns(tcc.getColumns().orElse(1)).build();
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public void setFillSlotsVertical(boolean fillSlotsVertical) {
        this.fillSlotsVertical = fillSlotsVertical;
    }

    public MarkedIntegerProperty getMinSize() {
        return this.minSize;
    }

    public void setMinSize(MarkedIntegerProperty minSize) {
        this.minSize = minSize;
    }

    public MarkedIntegerProperty getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(MarkedIntegerProperty maxSize) {
        this.maxSize = maxSize;
    }
}

